/* fsigma.c */
#include<stdio.h>
#include<math.h>
#include<stdlib.h>
#define PI   3.1415927
#define CON  0.0174532    /* degree to radian conversion factor */
#define NODP 20           /* number of data point selected randomly */
#define NOV  4            /* number of unknowns (fsigma, A, B, C) */
#define NOS 6             /* number of subsets to be anaysed */
FILE *ftp1;
float x1[40],y1[40],b[40][NOV],ba[NODP][NOV],u[NOV],c[NOV][NOV],LOAD,RAD;
float d[NOV],fringe[NOS],FACT;
int count,n[40],na[NODP];

void data_read()        /*default input file 'fsigma.dat' containing raw data */
{
  int i; ftp1 = fopen ("fsigma.dat","r"); /* first line has load, radius and */
  fscanf(ftp1,"%f %f %f",&LOAD,&RAD,&FACT); /* FACT - this is to convert */
  /* data from magnified image to actual model size - image dependent */
  /* Next line on-wards: radius in mm, theta in degrees and N in fringe orders */
  for(i = 0;i<40;i++) fscanf(ftp1,"%f %f %d",&x1[i],&y1[i],&n[i]);
}

void bmat()
{
  int i;
  float angle,nomi,denomi,x,y;
  for(i = 0;i<40;i++) /* raw data is from magnified image. FACT is used to */
   { x = FACT*x1[i]; /* convert */
     y = FACT*y1[i]; /* data to actual model size */
     nomi = 4.0*LOAD*RAD*(pow(RAD,2)-pow(x,2)-pow(y,2));
     denomi = PI*(pow((pow(x,2)+pow(y,2)+pow(RAD,2)),2)-4.0*(pow((y*RAD),2)));
     b[i][0] = nomi/denomi;  /* calculates S(x,y) */
     b[i][1] = x;  b[i][2] = y;  b[i][3] = 1.0; }
}

void randomise_data()
{
  int i,j,k;
  float xrand;
  for(i = 0;i<NODP;i++) /*randomly select rows in bmat and N */
    { xrand = rand()/32768.0;  j = (int)(40*xrand);  na[i] = n[j] ;
      for(k = 0;k<NOV;k++) ba[i][k] = b[j][k]; }
}

void bt_b_and_bt_N()
{
 int i,j,l;
 for(j = 0;j<NOV;j++)
   { for(i = 0;i<NOV;i++)
       { c[j][i] = 0.0;        /*bt_b */
         for(l = 0;l<NODP;l++)  c[j][i] = c[j][i]+ba[l][j]*ba[l][i]; } }
 for(i = 0; i<NOV;i++)         /*bt_N */
   { d[i] = 0.0; for(j = 0;j<NODP;j++) d[i] = d[i]+ba[j][i]*(float)na[j]; }
}

float solver()  /* Gauss elimination scheme */
{
 int ia,ib,ic,id,ie,i,j,io,ja,jb;
 float large,temp,sum,uu,f_val;
 ia = 0; ib = ia+1;
 do       /* pivotal  condensation */
  { large = fabs(c[ia][ia]); ie = ia;
    for(id = ib;id<NOV;id++)
      { if(fabs(c[id][ia]) > large) { large = fabs(c[id][ia]);  ie = id; } }
    if(ie != ia) /* interchanging iath row by eth row to get largest pivot */
       { temp = d[ia];  d[ia] = d[ie];  d[ie] = temp;
         for(io=0;io<NOV;io++)
           { temp = c[ia][io];  c[ia][io] = c[ie][io];  c[ie][io] = temp; } }
    for(i=ib;i<NOV;i++)  /*eliminitating the variable one by one */
      { uu = c[i][ia]/c[ia][ia];  d[i] = d[i]-uu*d[ia];
       for(j = ia;j<NOV;j++)  c[i][j] = c[i][j]-uu*c[ia][j]; }
    ia = ib; ib = ia+1;
  } while(ib != NOV);
 u[NOV-1] = d[NOV-1]/c[NOV-1][NOV-1];  ic = NOV-2; /* back-substitution */
 for(j=ic;j>=0;j--)  /* sum to find other u[j] */
   { sum=0.0;  for(ja = j;ja <= NOV-2;ja++)
                 { jb = ja+1;  sum = sum+u[jb]*c[j][jb]; }
     u[j] = (d[j]-sum)/c[j][j]; }  /* solving for u[j] */
 fringe[count] = 1.0/u[0];
 printf("\n\tMat. fringe value(N/mm/fringe) is");
 printf("%10.4f in %3d set",fringe[count],count+1);
 return(fringe[count]);
}

main()
{
  int i;
  float sumf,avg_fval ;
  printf("\n\n\n\n\n\n\n\n\n\n");
  printf(" ---------------------------------------------------------------------------\n");
  printf("   Software code accompanying the book \n\n");
  printf("   Digita Photoelasticity - Advanced Techniques and Applications \n\n");
  printf("   Author : Dr. K. Ramesh. \n\n");
  printf("   Publisher : Springer-Verlag Berlin-Heidelberg-New York-Tokyo.\n");
  printf(" ---------------------------------------------------------------------------");
  printf("\n\n\n\n\n\n");
  printf("Press any key to continue...\n");
  getch();
  for(i=0;i<=23;i++)
  printf("\n");
  data_read();  bmat();  sumf = 0.0;
  for(count = 0;count < NOS;count++)
    { randomise_data();  bt_b_and_bt_N();  solver();
      sumf = sumf+fringe[count]; }
  avg_fval = sumf/((float)NOS);
  printf("\n\tAverage material fringe value (N/mm/fringe): ");
  printf("%9.4f",avg_fval);
  fcloseall();
}
