#include<stdio.h>
#include<conio.h>
#include<graphics.h>
#include<dos.h>
#include<math.h>
#define pi 3.1415927
#define true 1
#define false 0
float disc_radius,disc_load,f_sigma,magnification,xscan,yscan;

float n_disc(float x,float y)  /* Calculates fringe orders for a disk */
{                              /* under diametral compression */
  float temp1,temp2,a,numer,denom,rsqr,frsqr,nc;
  rsqr = disc_radius*disc_radius;  temp1 = x*x;   temp2 = y*y;
  a = 4.0*disc_load*disc_radius/(pi*f_sigma);  numer = rsqr-temp1-temp2;
  denom = pow((temp1+temp2+rsqr),2)-4*rsqr*temp2;
  if(denom >= 1.0e-20) nc = a*numer/denom;  return(nc);
}

void drawline(float a1,float b1,float a2,float b2)
{
  int p1,q1,p2,q2;
  p1 = (int)319+a1*479/xscan;  q1 = (int) 239-b1*479/yscan;
  p2 = (int)319+a2*479/xscan;  q2 = (int) 239-b2*479/yscan; line(p1,q1,p2,q2);
}

void drawdiamond(float x,float y)
{
  int x1,y1;
  setcolor(RED);  x1 = 319+x*479/xscan;  y1 = 239-y*479/yscan;
  rectangle(x1-2,y1-2,x1+2,y1+2);
}

void main()
{
  FILE  *fp;
  int   gd=VGA,gm=VGAHI,i,scanwidth_x,scanwidth_y,sym_mode;
  int   order_flag,echo_flag,filled_flag,nopx,nopy,ndat,junk;
  char  field_choice,echo_choice,echo_data[20];
  float thickness,fringe_width,fringe_tolerance,xinc,yinc;
  float xdat,ydat,xpointint,x,y,n,n1,xpd,ypd,x1[36],y1[36];
  clrscr();
  printf("\n\n\n\n\n\n");
  printf(" ---------------------------------------------------------------------------\n");
  printf("   Software code accompanying the book \n\n");
  printf("   Digita Photoelasticity - Advanced Techniques and Applications \n\n");
  printf("   Author : Dr. K. Ramesh. \n\n");
  printf("   Publisher : Springer-Verlag Berlin-Heidelberg-New york-Tokyo.\n");
  printf(" ---------------------------------------------------------------------------");
  printf("\n\n\n\n\n\n");
  printf("Press any key to continue...");
  getch();
  clrscr();
  printf("\n");
  printf("   C I R C.  D I S K   P A R A M E T E R S   \n");
  printf("\n");
  printf("\t disc radius \t(mm) : "); scanf("%f",&disc_radius);
  printf("\t disc load   \t (N) : "); scanf("%f",&disc_load);
  printf("\n");
  printf("\n");
  printf("      M O D E L  P A R A M A T E R S         \n");
  printf("\n");
  printf("\t fsig  (N/mm per fringe) : "); scanf("%f",&f_sigma);
  printf("\t thick       \t(mm) : "); scanf("%f",&thickness);
  printf("\n");
  printf("\n");
  printf("\t Magnification Desired : "); scanf("%f",&magnification);
  printf("\t Mode of Symmetry Conditions  \n");
  printf("\t [1] xy-sym  [2] x-sym \n");
  printf("\t [3] non-sym [4] anti-sym : "); scanf("%d",&sym_mode);
  printf("\t Field (b-bright/d-dark)  : "); field_choice=getche();
  printf("\n\t Scanwidth_y (no. of pixels) : "); scanf("%d",&scanwidth_y);
  printf("\t Scanwidth_x (no. of pixels) : "); scanf("%d",&scanwidth_x);
  printf("\t Enter Fringe Width : ");  scanf("%f",&fringe_width);
  printf("\n");
  fringe_tolerance =  fringe_width/2.0;
  fflush(stdin);
  printf("\t Want to Echo data points ? [y/n] :");
  echo_choice=getchar();
  if (echo_choice=='y')
    { printf("\n\t Enter file name :");  scanf("%s",echo_data);
      fp=fopen(echo_data,"r");  echo_flag =true; }

  clrscr(); nopx = 479; nopy = 479;   /* no. of pixel in x & y direction  */
  xscan = 175/magnification;          /* window size of screen 175*175 mm */
  yscan = 175/magnification;
  xpd =  xscan/(nopx-1); ypd =  yscan/(nopy-1);
  xinc = xpd*scanwidth_x; yinc = ypd*scanwidth_y;
  initgraph(&gd,&gm," ");  setbkcolor(BLUE); /* initialisations */
  drawline(-xscan/2.0,0,xscan/2.0,0);  drawline(0,-yscan/2.0,0,yscan/2.0);
  rectangle(80,0,560,479);

  filled_flag = false; /* centre of the window is x = 0 and y = 0 */
  switch(sym_mode)     /* starting point of scan for various cases */
     {  case 1 : y = 0.0;  break;
        case 2 : y = 0.0;  break;
        case 3 : y = -disc_radius;  break;
        case 4 : y = 0.0;  break;   }

  do                              /*  scan in Y direction  */
   {  switch(sym_mode)
        {  case 1 : x = 0.0;  break;
           case 2 : x = -disc_radius;  break;
           case 3 : x = -disc_radius;  break;
           case 4 : x = -disc_radius;  break;  }
    do                        /*  scan in X direction  */
     {  n = n_disc(x,y);  order_flag = false;
        if (n >= 0.0)
         { switch(field_choice)
             { case 'b': n1 = fabs(n-floor(n)-0.5); /* bright field */
                         if(n1 <= fringe_tolerance) order_flag = true;
                         break;
               case 'd': if(n-floor(n) > 0.5) n1 = fabs(n-ceil(n));
                         else n1 = fabs(n-floor(n)); /* dark field */
                         if(n1 <= fringe_tolerance) order_flag = true;
                         break;  }
         }
       if (order_flag && !filled_flag) { xpointint = x; filled_flag = true; }
       if (filled_flag && !order_flag)
        { filled_flag = false;
          switch(sym_mode) /*  various cases are used to increase speed  */
           { case 1: drawline(xpointint,y,x,y); drawline(-xpointint,-y,-x,-y);
                     drawline(xpointint,-y,x,-y);
                     drawline(-xpointint,y,-x,y);   break;
             case 2: drawline(xpointint,y,x,y);
                     drawline(xpointint,-y,x,-y);   break;
             case 3: drawline(xpointint,y,x,y);     break;
             case 4: drawline(xpointint,y,x,y);
                     drawline(-xpointint,-y,-x,-y); break; }
        }   x = x+xinc;
     }  while(x <= disc_radius+3); y = y+yinc; /*  scan in X direction  */
   } while(y <= disc_radius+3);        /*  scan in Y direction  */

  if(echo_flag)
  { fscanf(fp,"%d",&ndat);             /*  ---Echo data points---   */
    for(i=0;i<ndat;i++)
      { fscanf(fp,"%f %f %d",&xdat,&ydat,&junk);
      /*  x1[i] = xdat*cos(pi*ydat/180);
        y1[i] = xdat*sin(pi*ydat/180);*/
        drawdiamond(xdat,ydat);
      } 
  }
  fclose(fp);
  getch();
  closegraph();
} /* end of main */

