# include <stdio.h>       
# include <stdlib.h>
# include <graph.h>
# include <dos.h>
# include <math.h>

union REGS xregs,reg,iReg,oReg;//Registers for BIOS 
struct SREGS sregs;

#define esc 27
#define ncolors 16
#define drawline(x1,y1,x2,y2){_moveto(x1, y1),\
_lineto(x2, y2);}
#define setpalcolor(iclr){WriteColorReg(iclr,\
(unsigned char)(palette[iclr] & 0x3F),\
(unsigned char)((palette[iclr] >> 8) & 0x3F),\
(unsigned char)((palette[iclr] >> 16) & 0x3F));}
#define makepalcolor(iclr,red,green,blue){palette[iclr]=\
(((long)((blue)<<8|(green))<<8)|(red));setpalcolor(iclr);}

#define ESC 0x1B      // Definitions for mouse operations
#define RBUTTON 0x02
#define LBUTTON 0x01
#define RESET 0
#define SHOWCRSR 1
#define HIDECRSR 2
#define GETSTATUS 3
#define SETPOS 4
#define GETPRESS 5
#define GETRELEASE 6
#define MFUNC iReg.x.ax
#define MRETURN oReg.x.ax
#define MOUSEX oReg.x.cx
#define MOUSEY oReg.x.dx
#define BUTTONS oReg.x.bx
#define NEWMOUSEX iReg.x.cx
#define NEWMOUSEY iReg.x.dx
#define MINT 0x33           
#define mint(m);{MFUNC=(m);\
int86(MINT,&iReg,&oReg);}
int mouseon;              
#define findmouse();{mint(RESET);if(MRETURN)\
{mouseon=-1;mint(SHOWCRSR);}else mouseon=0;}
#define showmouse() mint(SHOWCRSR)
#define hidemouse() mint(HIDECRSR)
#define getmousebuttons(lb,rb);{mint(GETSTATUS);\
lb=BUTTONS&1;rb=(BUTTONS&2)>>1;}
#define getmousepos(mx,my);{mint(GETSTATUS);\
mx=MOUSEX,my=MOUSEY;}
#define setmousepos(mx,my);{NEWMOUSEX=mx,\
NEWMOUSEY=my;mint(SETPOS);}
#define getmouse();{do{mint(GETSTATUS);}\
while(BUTTONS==0);do{mint(GETSTATUS);}while(BUTTONS!=0);}
#define mousewait();{int mb;\
while(!kbhit()){mint(GETSTATUS);\
mb=BUTTONS;while(BUTTONS!=0)\
{mint(GETSTATUS);}switch(mb)\
{case 1:ungetch(13);break;case 2:ungetch(27);}}}

#define linear_scaling(g)((int)(((g-0)/((256-0)/ncolors))+1))
FILE *tgafile;
long palette[256];char text[200],image_name[40];
int centre[2][2],data_buffer[3][200],ii,jj,xx,yy,channel;
float d,fringe_buffer[200],xlength,ylength;
typedef struct
{char idlength;//length of image ID string 
 char colormaptype;//1 if a color-map is included 
 char imagetype;//Image type:0=>no image 1=>color-map
 //2=>true color     3=>monochrome  
 unsigned int colormapstart;//index to start of map 
 unsigned int colormaplength;//number of map entries 
 char colormapbits;          //number of bits per entry 
 unsigned int xstart;         //top left corner of image 
 unsigned int ystart;
 unsigned int width;         //size of image in pixels 
 unsigned int depth;
 char bits;                  //number of bits per pixel 
 char descriptor;   //0x20 means start at top left,
 //0x21 means top right,0x00 means bottom left
 // 0x01 means bottom right 
}TGAHEADER;
TGAHEADER tga;
FILE *fp;

void mode_text_deletor(void);void delaying(unsigned);
void FindAspectRatio(void);
void WriteColorReg(int,int,int,int);
void MousePositionText(void);void plot(int,int,int);
void PointMarker(int,int);float PixelsPerMm(int);

void GetFileNames(void){// open a Targa file 
_setvideomode(_DEFAULTMODE);
printf("Enter TGA Image Name\n");
scanf("%s",image_name);
printf("Enter CHANNEL to plot(Default:GREEN)\n");
printf("1.Red\n");printf("2.Green\n");printf("3.Blue\n");
printf("Want to change[y/n]:");if(getche()=='y')
{printf("\nSelected Channel::");scanf("%d",&channel);}
else channel = 2;}

int opentga(char *filename){int i, j, c, r, g, b;
if((tgafile=fopen(filename,"rb"))==NULL) 
{printf("No Such TARGA File!Hit A Key!");getch();
_setvideomode(_DEFAULTMODE);exit(1);}
// read the file header 
memset((char*)&tga,0,sizeof(TGAHEADER));
tga.idlength=getc(tgafile);tga.colormaptype=getc(tgafile);
tga.imagetype=getc(tgafile);tga.colormapstart=getw(tgafile);
tga.colormaplength=getw(tgafile);tga.colormapbits=getc(tgafile);
tga.xstart=getw(tgafile);tga.ystart=getw(tgafile);
tga.width=getw(tgafile);tga.depth=getw(tgafile);
tga.bits=getc(tgafile);tga.descriptor=getc(tgafile);

// read the image id 
if(tga.idlength)
fseek(tgafile,(long)tga.idlength,SEEK_CUR);
// read the color map 
if((tga.colormaptype)&&(tga.bits==8))
{for(i=0;i<tga.colormaplength;++i){r=getc(tgafile);
g = getc(tgafile);
switch(tga.colormapbits)
   {case 15: case 16:         // five bits per color 
       b = g << 3;
       g = ((g >> 5) & ((r & 3) << 3)) << 2;
       r = r & 252;break;
    case 24:                  // eight bits per color  
       b = getc(tgafile);break;
    case 32:                  // skip the alpha channel 
       r=g;g=getc(tgafile);b=getc(tgafile);break;
    }
    makepalcolor(i,(b >> 2), (g >> 2), (r >> 2));
       }
   }
else   
 {for(i=0;i<ncolors;i++)
 {g=i*(256/ncolors);
 makepalcolor(i,(g>>2),(g>>2),(g>>2));}}
 if(ferror(tgafile)) return(0);else return(1);
}

int readtga(void){int x,y,c,R,G,B,i,d,e,
 xinc,yinc,xstart,ystart,xend,yend;
// Compressed Files will not be read
if(tga.imagetype>3)return(0);
if(tga.descriptor&0x20)    // from the top down 
yinc=1,ystart=tga.ystart,yend=tga.ystart+tga.depth;
else                       // from the bottom up 
yinc=-1,ystart=tga.ystart+tga.depth,yend=tga.ystart;
if(tga.descriptor&0x10)    // right to left 
xinc=-1,xstart=tga.xstart+tga.width,xend=tga.xstart;
else                       // left to right 
xinc=1,xstart=tga.xstart,xend=tga.xstart+tga.width;
for(y=ystart;y!=yend;y+=yinc){if(kbhit())
if(getch()==27)break;for(x=xstart;x!=xend;x+=xinc)
    {R=getc(tgafile);G=getc(tgafile);
switch(tga.bits){case 15:   
  case 16:B=G<<3;G=((G>>5)&((R&3)<<3))<<2;R=R&252;break;
  case 24:B=getc(tgafile);break;
  case 32:R=G;G=getc(tgafile);B=getc(tgafile);break;
                 }
c=linear_scaling(G);d=linear_scaling(R);
e=linear_scaling(B);
      if(channel==1) plot(x,y,d);
 else if(channel==2) plot(x,y,c);
 else if(channel==3) plot(x,y,e); else ;
    }                       
 }
fclose(tgafile);if(ferror(tgafile))return(0);else return(1);}

int closetga(void){fclose(tgafile);if(ferror(tgafile))
return(0);else return(1);}

void WriteColorReg(int color,int r,int g,int b){
reg.x.ax=0x1010;reg.x.bx=color;reg.h.ch=g;reg.h.cl=b;
reg.h.dh=r;int86(0x10,&reg,&reg);}

void plot(int x,int y, int color){
#define graph(index,val){outp(0x3CE,index);outp(0x3CF,val);}
int dummy,mask;char far *address;
address=(char far*)0xA0000000L+(long)y*640/8L
+((long)x/8L);
mask=0x80>>(x%8);graph(8,mask);graph(5,2);
dummy=*address; *address=color;graph(5,0);graph(8,0xFF);}

void PointMarker(int xCentre,int yCentre){
    drawline(xCentre-4,yCentre,xCentre+4,yCentre);
    drawline(xCentre,yCentre-4,xCentre,yCentre+4);}

void MousePositionText(void){_settextposition(1,66);
sprintf(text,"x::%d  y::%d",xx,yy);_outtext(text);}

void delaying(unsigned value) {int i;double x,y;
      for(i=0;i<=500*value;i++){x= sin(i);y= cos(x);}}

void AssignOrigin(void){int lb, rb;
findmouse();if(mouseon){while(1){showmouse();
getmousebuttons(lb,rb);if(rb){while(rb)
{getmousebuttons(lb,rb);}break;}else if(lb){getmousepos(xx,yy);
hidemouse();mousewait();PointMarker(xx,yy);
centre[0][0] = xx;centre[1][0] = yy;
MousePositionText();delaying(50);showmouse();
getmousebuttons(lb, rb);}}hidemouse();}
else  _outtext("No mouse detected.");}

void coor_specifier(void){int lb,rb;
findmouse();if(mouseon){showmouse();
while(1){getmousebuttons(lb, rb);
if(rb){while(rb){getmousebuttons(lb, rb);}break;}
else if(lb){getmousepos(xx,yy);hidemouse();
mousewait();PointMarker(xx,yy);data_buffer[0][jj]=xx;
data_buffer[1][jj]=yy;
data_buffer[2][jj]=255;fringe_buffer[jj]=d;   
_settextposition(1,15);sprintf(text,"No Of Points Collected::%d",jj+1);
_outtext(text);MousePositionText();jj++;delaying(50);
showmouse();getmousebuttons(lb, rb);}}hidemouse();}
else _outtext("No mouse detected.");}

void mode_text_deletor(void){
_setviewport(0,0,640,30);_clearscreen(_GVIEWPORT);
_setviewport(0,0,640,480);  }

void data_collector(void){char ch;
do{mode_text_deletor();_settextposition(1,1);_settextcolor(15);
   sprintf(text,"PRESS MODE('a','m','c','f','d'or 'esc')::");
  _outtext(text);ch = getche();
switch(ch){
case 'c':_settextposition(2,13);
sprintf(text,"Assign Origin:(Click at required pixel,'R'\
button to exit)");_outtext(text);AssignOrigin();break;
case 'f':mode_text_deletor();_settextposition(1,25);
sprintf(text,"FRINGE::");_outtext(text);scanf("%f",&d);break;
case 'd':mode_text_deletor();_settextposition(2,25);
sprintf(text,"COLLECT DATA(Mouse 'R' Button to finish)");
_outtext(text);coor_specifier();break;
case'a':FindAspectRatio();break;
case'm':mode_text_deletor();_settextposition(2,25);
sprintf(text,"Pixels/mm ::%f,Hit A Key!",PixelsPerMm(1));
_outtext(text);getch();break;
default:continue;}
  }while(ch!=esc);}

#define HORZ 1
#define VERT 2

float PixelsPerMm(int status){   
int lb, rb, mx, my, oldmx, oldmy, x1, y1;
findmouse();if(mouseon){mode_text_deletor();
_settextposition(1,1);
_outtext("Drag with the left mouse button ON.(RIGHT to 'esc')");
showmouse();while(1){getmousebuttons(lb, rb);
  if(rb){ // Wait for the button release
while(rb) {getmousebuttons(lb, rb);} break; }
  else if(lb){getmousepos(x1, y1);
  mx = oldmx = x1, oldmy = my = y1;
  drawline(x1-4,y1-4,x1+4,y1+4);delaying(50);
while(lb){getmousepos(mx, my);
  if(mx!=oldmx) // Constrain the mouse to horizontal move
 {if(status==HORZ)my=y1;else if(status==VERT)mx=x1;
  setmousepos(mx, my);xx=oldmx=mx,yy=oldmy=my;
  showmouse();MousePositionText();}getmousebuttons(lb, rb);
     }mode_text_deletor();delaying(50);
     setmousepos(mx+20,my+20);drawline(x1,y1,mx,my);
     drawline(mx-4,my-4,mx+4,my+4);_settextposition(1,5);
     sprintf(text,"Enter the Real Length::");_outtext(text);
if(status == HORZ){scanf("%f",&xlength);
          return((float)(mx-x1+1)/(float)xlength);}
if(status==VERT){scanf("%f",&ylength);
          return((float)(my-y1+1)/(float)ylength);}
  showmouse();}}hidemouse();
  }else _outtext("No mouse detected.");}

void FindAspectRatio(void){float x_length,y_length;
x_length=PixelsPerMm(1);y_length=PixelsPerMm(2);
mode_text_deletor();_settextposition(2,20);
sprintf(text,"Aspect Ratio::%f,\
Hit A Key!",x_length/y_length);_outtext(text);getch();}

void main(void){char data_fname[40];int k;int i;
printf("\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n");
printf(" ---------------------------------------------------------------------------\n");
printf("   Software code accompanying the book \n\n");
printf("   Digita Photoelasticity - Advanced Techniques and Applications \n\n");
printf("   Author : Dr. K. Ramesh. \n\n");
printf("   Publisher : Springer-Verlag Berlin-Heidelberg-New York-Tokyo.\n");
printf(" ---------------------------------------------------------------------------");
printf("\n\n\n\n\n\n");
printf("Press any key to continue...\n");
getch();
for(i=0;i<=23;i++)
printf("\n");
GetFileNames();_setvideomode(_VRES16COLOR);
opentga(image_name);readtga();          
data_collector();_setvideomode(_DEFAULTMODE);

printf("Enter data file name\n");scanf("%s",data_fname);
if((fp = fopen(data_fname,"wt"))==NULL)
printf("Error in opening file %s",data_fname);
fprintf(fp,"%d   %d\n",centre[0][0],centre[1][0]);
for(k=0;k<jj;k++) fprintf(fp,"%4d  %4d  %4d  %4.5f\n",
data_buffer[0][k],data_buffer[1][k],
data_buffer[2][k],fringe_buffer[k]);
_setvideomode(_DEFAULTMODE);}

