// Two specified quadrants are used for working 
// LUT map 1 is used to do the pseudo coloring 
#include "curupip.h"

void go_color(region_table, color_defn_table) // function to do the actual   
 struct gray_range region_table[max_no_of_colors];  // pseudo coloring of 
 int color_defn_table[max_no_of_colors][3];         // the picture

{ 
 int color, i;
 char c, lut_buffer_blue[256], lut_buffer_green[256], lut_buffer_red[256];

 fg_dquad(quad1);  for (i=0; i< 256; i++) 
                    { lut_buffer_blue[i] = lut_buf_blue[i];
                      lut_buffer_green[i]= lut_buf_green[i];
                      lut_buffer_red[i]  = lut_buf_red[i]; }
 for (color= black; color< max_no_of_colors ; color++) 
  { c=getch();
     for (i=region_table[color].low; i<= region_table[color].high; i++) 
      { lut_buffer_blue[i]=color_defn_table[color][blue_out];
        lut_buffer_green[i]=color_defn_table[color][green_out];
        lut_buffer_red[i]=color_defn_table[color][red_out]; }
     fg_lutd(lut_used,blue_out,0,256,lut_buffer_blue);
     fg_lutd(lut_used,green_out,0,256,lut_buffer_green);
     fg_lutd(lut_used,red_out,0,256,lut_buffer_red);
  }
} // end_of go_color 


void draw_menu() // draw the color menu 
{ 
 int val, i;
 fg_dquad(quad1);
 fg_setind(black); fg_rectf(0+qd1.x, 0+qd1.y, 120+qd1.x, 511+qd1.y);
 fg_setind(blue);  fg_rect(0+qd1.x, 0+qd1.y, 120+qd1.x, 511+qd1.y);
 fg_setind(cyan);  fg_rect(2+qd1.x, 2+qd1.y, 118+qd1.x, 509+qd1.y);
 fg_setind(gray);  fg_rectf(37+qd1.x, 5+qd1.y, 116+qd1.x, 506+qd1.y);
 fg_rectf(5+qd1.x, 5+qd1.y, 115+qd1.x, 26+qd1.y);
 fg_moveto(33+qd1.x,24+qd1.y); fg_setind(black); fg_text("MENU",2);

// the value 20 in (20 + size * (i+1) <= 508 is obtained as y1 of 
// black rect at the top of menu - a gap of 5 at the bottom       
 for (i= black; (i< max_no_of_colors) && (25 + size * (i+1) <= 508); i++) 
 { fg_setind(i);
   fg_rectf(7+qd1.x, 32 + i*size+qd1.y, 32+qd1.x, 52 + i*size+qd1.y);
   fg_setind(white); 
   fg_rect(5+qd1.x, 30 + i*size+qd1.y, 34+qd1.x, 54 + i*size+qd1.y);
   fg_moveto(41+qd1.x, 45 + i*size+qd1.y);
   fg_tchar('0' + default_regions[i].low/100,1);
   val = default_regions[i].low % 100;
   fg_tchar('0' + val/10, 1); fg_tchar('0' + val%10, 1);
   fg_text(" - ", 1);
   fg_tchar('0' + default_regions[i].high/100,1);
   val = default_regions[i].high % 100;
   fg_tchar('0' + val/10, 1); fg_tchar('0' + val%10, 1);
 }
} // end_of draw_menu 

void pseudo_color()  // quad1 is the work space and displays menu etc. 
 {                   // quad2 displays the pcolored picture 
 int l1 = 0, h1 = 255, l2 =max_no_of_colors-1, h2 = 245, i, color;
 int colr_out, val;
 char c, gen_buf[512];
 FILE  *fopen(), *fil_point, *fp2;
 fg_quadm(1); fg_setwin(0,0,511,511); fg_zoom(0); fg_pan(0); fg_scroll(0);
 fg_dquad(quad1); fg_cpws(quad2,quad1);

// read in the set of colors to be used into the array lut_color[][] 
 fil_point = fopen(color_filename,"r");
 for (color=0; (color< max_no_of_colors) && (val!=EOF) ; color++) 
  { for (colr_out=blue_out; colr_out<= red_out; colr_out++) 
     { if (!feof(fil_point)) 
          { fscanf(fil_point,"%d",&val);
            lut_color[color][colr_out] = val; } }
  }
 fclose(fil_point);

// Rescale all the LUTs so that 0 to l1 levels are at l2 for the picture   
// snapped and h1 to 255 are at h2. This enhances the contrast. Further the 
// levels 0 thro l2 are needed for implementing pseudo color imaging. 
 fg_scaling(l1,max_no_of_colors-1,h1,h2,lut_buf_blue);
 fg_scaling(l1,max_no_of_colors -1,h1,h2,lut_buf_green);
 fg_scaling(l1,max_no_of_colors -1,h1,h2,lut_buf_red);
 fg_lutm(lut_used);
 fg_lutd(lut_used,in_col,0,256,lut_buf_blue);

// assign the menu colors to the bottom 15 to 20 locations of the LUT 
// max_no_of colors =15 to 20. LUT modified and used is lut_used 
 for (color=0; color< max_no_of_colors; color++) 
  { lut_buf_blue[color] = lut_color[color][blue_out];
    lut_buf_green[color] = lut_color[color][green_out];
    lut_buf_red[color] = lut_color[color][red_out]; }

 fg_lutd(lut_used,blue_out,0,256,lut_buf_blue);
 fg_lutd(lut_used,green_out,0,256,lut_buf_green);
 fg_lutd(lut_used,red_out,0,256,lut_buf_red);

// read in the default regions for pseudo_coloring 
 fp2 = fopen(region_set_file,"r");
 for (i=0; (i< max_no_of_colors) && (val!=EOF); i++) 
  { if ( !feof(fp2) ) 
     { fscanf(fp2,"%d", &val); default_regions[i].low = val; }
    if (!feof(fp2)) 
     { fscanf(fp2,"%d", &val); default_regions[i].high = val; }
  }
 fclose(fp2); draw_menu();
} // end_of pseudo_color 

void uncolor()
{
 fg_lutd(lut_used,blue_out,0,256,lut_buf_blue);
 fg_lutd(lut_used,green_out,0,256,lut_buf_green);
 fg_lutd(lut_used,red_out,0,256,lut_buf_red);
}

void pseudo_shell()
{  
 char c;
 int i;

 quad1 %=4;    // use modulo 4 of the given value 
 quad2 %= 4;   // use modulo 4 of the given value to avoid trouble 
 if (quad1==quad2)
    printf("Error - Please specify two different quadrants\n");
 else 
  { printf(" Workspace quad = %2d.  Display quad = %2d \n", quad1, quad2);
    qd1.x=(quad1/2) * 512; qd1.y=(quad1%2) * 512;
    qd2.x=(quad2/2) * 512; qd2.y=(quad2%2) * 512;
    pseudo_color();
    printf("                     P S E U D O     C O L O R I N G \n");
    for (i=1; i<8; i++) printf("\n");
    printf("\t \t C O M M A N D   S U M M A R Y \n \n \n");
    printf("\t \t  M  -  C O L O R   M E N U \n \n");
    printf("\t \t  D  -  D I S P L A Y   Q U A D \n \n");
    printf("\t \t  C  -  I N T E N S I T Y   D I S P L A Y \n \n");
    printf("\t \t  G  -  G O   C O L O R \n \n");
    printf("\t \t  U  -  U N C O L O R \n \n");
    printf("\t \t  E  -  E X I T \n \n \n ");
    printf("\t C H O I C E ? ");

    do 
     { for (i=1; i<9000; i++) {} putch(' ');
       printf(bck_spc); c=getch();
       switch (c) {
           case 'M':
           case 'm': putch(c); printf(bck_spc);
                     fg_dquad(quad1); break;
           case 'D':
           case 'd': putch(c); printf(bck_spc);
                     fg_dquad(quad2); break;
           case 'C':
           case 'c': putch(c); printf(bck_spc);
                     expanded_curs(); break;
           case 'G':
           case 'g': putch(c); printf(bck_spc);
                     go_color(default_regions,lut_color);
                     break;
           case 'U':
           case 'u': putch(c); printf(bck_spc);
                     uncolor(); break;
           case 'E':
           case 'e': putch(c); printf(bck_spc);
                     break;
           default : break;
            } // end_switch 
     } while ((c !='e') && (c !='E'));
     printf("\n \n Pseudo coloring over\n"); 
   } // end_else 
} // end_of pseudo_shell 

main()
{
  char work_buf[wbuf_size], img_file[13];
  printf("\n\n\n\n\n\n\n\n\n\n");
  printf(" ---------------------------------------------------------------------------\n");
  printf("   Software code accompanying the book \n\n");
  printf("   Digita Photoelasticity - Advanced Techniques and Applications \n\n");
  printf("   Author : Dr. K. Ramesh. \n\n");
  printf("   Publisher : Springer-Verlag Berlin-Heidelberg-New York-Tokyo.\n");
  printf(" ---------------------------------------------------------------------------");
  printf("\n\n\n\n\n\n");
  printf("Press any key to continue...\n");
  getch();
  for(i=0;i<=23;i++)
  printf("\n");
  initialise_pip();
 printf("\nPseudo_coloring\n");
 printf("\nWorkspace quad is "); scanf("%1d", &quad1);
 printf("\nDisplay quad is ");   scanf("%1d", &quad2);
 fg_dquad(quad2 %=4);  
 printf("\nFile :");  scanf("%s",img_file);
 fg_frdisk(wbuf_size, quad2 %=4 , img_file, work_buf, current_seg);
 pseudo_shell();
 fg_exit();
}
