// This program is for time averaging over a maximum of four 512 x 512   
// pictures and uses full resolution without zoom while snapping.   

#include "pipdef.h"
void take512(n,quad_no)
{
 int l1 = 0, h1 = 255, l2 = 20, h2 = 235, y_cood, x_cood, i;
 char c,gen_buf[512], lut_buf[256], buf1[512];
 quad_no %=4;    // use modulo 4 of the given value   
 n %= 5;         // use modulo 5 of the given value to avoid trouble   
 printf("quad_no = %2d.   # of quads = %2d \n", quad_no, n);
 fg_quadm(1); fg_setwin(0,0,511,511); fg_chan(2);
 fg_sync(1); fg_dquad(quad_no); fg_snap(1);
 fg_autoset();  // setup the gain and offset to the correct value   
 fg_zoom(0);      // do not use zoom   
 fg_sbuf(0);    // enable input from camera to the screen   

 fg_scaling(l1,l2,h1,h2,lut_buf); //  rescale all the LUTs so that 0 to l1   
 // levels are at l2 for the picture snapped and h1 to 255 are at h2   
 // this enhances the contrast. Further the levels 0 thro l2 are needed   
 // for implementing a menu driven pseudo color imaging.   

 fg_lutm(lut_used); fg_lutd(lut_used,all_colours,0,256,lut_buf);
 // a pause for object adjustment   
 printf("Press enter to start snapping\n"); c = getch();
 fg_sbuf(1); fg_pan(0); fg_scroll(0);

 if (n<=1) fg_snap(1);

 else {       // start grabbing the picture   
   for (i=0; i < n; i++)
	 {  fg_dquad(i);     // choose quadrant i   
	fg_snap(1); }   // A 512 x 512 image  is snapped   
 // start averaging now and put the contents in quad quad_no specified.   
	for (y_cood=0; y_cood< 512; y_cood++)
	  { for (x_cood=0; x_cood < 512; x_cood++) gen_buf[x_cood] = 0;
		for (i=0; i<n; i++)
		  { fg_rowr(y_cood, i, buf1);
		for (x_cood=0; x_cood< 512 ; x_cood++)
		gen_buf[x_cood] += buf1[x_cood] / n;
 // averaged over all the quadrants 0 thro n for a given (x,y)   
		  }
	 fg_dquad(quad_no); fg_roww(y_cood, quad_no, gen_buf);
	  }
   printf("Averaging completed.\n");
	  }
}


main()
{
 int i=1, j=0;
  printf("\n\n\n\n\n\n\n\n\n\n");
  printf(" ---------------------------------------------------------------------------\n");
  printf("   Software code accompanying the book \n\n");
  printf("   Digita Photoelasticity - Advanced Techniques and Applications \n\n");
  printf("   Author : Dr. K. Ramesh. \n\n");
  printf("   Publisher : Springer-Verlag Berlin-Heidelberg-New York-Tokyo.\n");
  printf(" ---------------------------------------------------------------------------");
  printf("\n\n\n\n\n\n");
  printf("Press any key to continue...\n");
  getch();
  for(i=0;i<=23;i++)
  printf("\n");
 initialise_pip();
 printf("# of quads over which I average = ");
 scanf("%1d", &i);
 printf("Quad into which I put the output image = ");
 scanf("%1d", &j);
 take512(i,j);
 fg_exit();
 }




