#include "pipdef.h"

// all_colours includes input LUT (look  up table) also 

void takepic(n,quad_no)
int n,quad_no;
{
 int l1 = 0, h1 = 255, l2 = 20, h2 = 235, y_cood, x_cood, i;
 char c, gen_buf[512], lut_buf[256], buf1[512], buf2[512];
 quad_no %=4;  // use modulo 4 of the given value to avoid trouble 
 n %= 5;       // use modulo 5 of the given value to avoid trouble 
 printf("\nquad_no = %2d.   # of quads = %2d \n", quad_no, n);
 fg_quadm(1); fg_setwin(0,0,511,511);
 fg_chan(2);  fg_sync(1);
 fg_dquad(quad_no);      // set to specified quad 
 fg_snap(1);      // just snap a picture for gain adjustment 
 fg_autoset();  // setup the gain and offset to the correct value 
 fg_sbuf(0);    // enable input from camera to the screen 
 fg_zoom(1);    // enable zoom 
 fg_scaling(l1,l2,h1,h2,lut_buf); // rescale all the LUTs so that 0 to l1 
 // levels are at l2 for the picture snapped and h1 to 255 are at h2 
 // this enhances the contrast. Further the levels 0 thro l2 are needed 
 // for implementing a menu driven pseudo color imaging. 
 fg_lutm(lut_used); fg_lutd(lut_used,all_colours,0,256,lut_buf);
 printf("\nPress enter to start snapping\n"); c = getch();
 fg_pan(0); fg_scroll(0);   //display sub-quad 1 

 if (n==0) fg_snap(1);
 else { fg_sbuf(1);
// start grabbing the picture. Note screen is set to sub-quad 1 currently 
 for (i=0; i < n; i++) 
  { fg_dquad(i);     // choose quadrant i 
	fg_snap(1);    // so only 1 quarter [256x256] of a 512x512 quad is seen 
	fg_pan(256);   // sub-quadrant 2 
	fg_snap(1);
	fg_scroll(256); // sub-quadrant 3. Note count is clockwise. 
	fg_snap(1); fg_pan(0);  // sub-quadrant 4. 
	fg_snap(1); fg_scroll(0); }    // display sub-quadrant 1 again 
 fg_zoom(0);  // un-zoom  
 fg_dquad(quad_no); // display specified quad 
 printf("\n Would you like to average ?  [n]");
 printf(bck_spc); printf(bck_spc); c=getch();
 switch (c) {
	  case 'n' :
	  case 'N' :
	  case crlf: printf("\n Exit takezoom \n"); break;
	  case 'y' :
	  case 'Y' : putch('y'); printf("\n Averaging\n");
 // start averaging now and put the contents in quad quad_no specified. 
	  for (y_cood=0; y_cood<256; y_cood++)
	   { for (x_cood=0; x_cood < 512; x_cood++) gen_buf[x_cood] = 0;
		 for (i=0; i<n; i++)
		   { fg_rowr(y_cood, i, buf1); fg_rowr(y_cood+256, i, buf2);
		// sum over one quadrant for all x 
		 for (x_cood=0; x_cood<256 ; x_cood++)
		 gen_buf[x_cood] += (buf1[x_cood] + buf1[x_cood+256] +
		 buf2[x_cood] + buf2[x_cood+256]) / (n * 4);
// and average over all the quadrants 0 thro n for a given (x,y) 
		   }
// now write it into the desired quad 
// scroll & pan positions are both 0 & quad_no is displayed currently. 
		  fg_roww(y_cood, quad_no, gen_buf);
	   }
   fg_zoom(1);        // zoom again 
   printf("Averaging completed.\n"); break;
		 } // end_switch 

	  } // end_else 
}

main()
{
 int i=1, j=0;
  printf("\n\n\n\n\n\n\n\n\n\n");
  printf(" ---------------------------------------------------------------------------\n");
  printf("   Software code accompanying the book \n\n");
  printf("   Digita Photoelasticity - Advanced Techniques and Applications \n\n");
  printf("   Author : Dr. K. Ramesh. \n\n");
  printf("   Publisher : Springer-Verlag Berlin-Heidelberg-New York-Tokyo.\n");
  printf(" ---------------------------------------------------------------------------");
  printf("\n\n\n\n\n\n");
  printf("Press any key to continue...\n");
  getch();
  for(i=0;i<=23;i++)
  printf("\n");
 fg_inifmt(620,1,0,0,1,1);  // Initialise and load PIP with input zoom 
 fg_chan(2); fg_sync(1); fg_quadm(1);
 printf("\ntakezoom");
 printf("\n# of quads over which I average = "); scanf("%1d", &i);
 printf("Quad into which I put the output image = "); scanf("%1d", &j);
 takepic(i,j); fg_exit();
}
