#include "curupip.h"
#include <time.h>
#include "threspip.h"
#include "orthopip.h"
#include "thinpip.h"

main()
{ 
 char work_buf[wbuf_size],work_file_name[50],scan_choice,ch;
 int i,j,flag;
 time_t lt1,lt2;
 FILE *fp1;
 printf("\n\n\n\n\n\n\n\n\n\n");
 printf(" ---------------------------------------------------------------------------\n");
 printf("   Software code accompanying the book \n\n");
 printf("   Digita Photoelasticity - Advanced Techniques and Applications \n\n");
 printf("   Author : Dr. K. Ramesh. \n\n");
 printf("   Publisher : Springer-Verlag Berlin-Heidelberg-New York-Tokyo.\n");
 printf(" ---------------------------------------------------------------------------");
 printf("\n\n\n\n\n\n");
 printf("Press any key to continue...\n");
 getch();
 for(i=0;i<24;i++)
 printf("\n");
 printf("\n \t \t IMAGE FILE : "); scanf("%s",work_file_name);
 initialise_pip();
 fg_dquad(0); quad2 = 0; qd2.x = 0; qd2.y = 0;
 fg_frdisk(wbuf_size,0,work_file_name,work_buf,current_seg);
 for (i=1;i<24;i++) printf("\n");
 printf("\tT H I N N I N G    A L G O R I T H M S\n");
 printf("\n\n\t\t[a] - Mask-based algorithm-I\n"); 
 printf("\t\t[b] - Mask-based algorithm-II\n");
 printf("\t\t[c] - Binary-based algorithm\n");
 printf("\t\t[d] - Global Thinning (without saddle point improvement)\n");
 printf("\n\t\tEnter choice -> ");
 scan_choice = getche(); printf("\n");  window_cursor();
 switch (scan_choice)
  {
   case 'a' : time(&lt1); yatagai(); time(&lt2);
		  fp1 = fopen("yatagai.tim","w"); //stores the elapsed time
		  fprintf(fp1,"Elapsed time: %d seconds\n",lt2-lt1);
		  fclose(fp1);
		  fg_todisk(wbuf_size,2,"yatagai.img",work_buf,current_seg);
		  break;
   case 'b' : time(&lt1); umezaki(); time(&lt2);
		  fp1 = fopen("umezaki.tim","w");
		  fprintf(fp1,"Elapsed time: %d seconds\n",lt2-lt1);
		  fclose(fp1);
		  fg_todisk(wbuf_size,2,"umezaki.img",work_buf,current_seg);
		  break;
   case 'c' : time(&lt1); thresholding(); fg_dquad(1); fg_setind(0);
		  fg_clear(0,7); for (i=1;i<10;i++) chen_and_taylor();
		  printf("\n\t\a\a\aOnce more ? (y/n) ");
		  while ((ch=getche()) != 'n')
		{ printf("\n"); chen_and_taylor();
		  printf("\n\t\a\a\aOnce more ? (y/n) "); }
		  fg_dquad(2);
		  for (j=winxy[1]+1;j<winxy[3];j++)
		 for (i=winxy[0]+1;i<winxy[2];i++) // skeleton superposition
		   if ( fg_pixr(i,j+512) < 100) fg_pixw(i+512,j,250);
		  time(&lt2);
		  fp1 = fopen("chen.tim","w");
		  fprintf(fp1,"Elapsed time: %d seconds\n",lt2-lt1);
		  fclose(fp1);
		  fg_todisk(wbuf_size,2,"chen.img",work_buf,current_seg);
		  break;
   case 'd' : time(&lt1); thresholding(); global_thinning();
		  time(&lt2);
		  fp1 = fopen("Ramesh.tim","w");
		  fprintf(fp1,"Elapsed time: %d seconds\n",lt2-lt1);
		  fclose(fp1);
		  fg_todisk(wbuf_size,0,"ramesh.img",work_buf,current_seg);
		  break;
  }// end of scan_choice
  fg_exit();
 }
