/* A 3X3 mask search program with discontinuity and interlaced fringes. */

#include "curupip.h"
int i,j,status,tmpdir;
unsigned int Si[500],Sj[500];
unsigned long value1;
static int count = 0;
char work_buf[wbuf_size], work_file_name[50];
FILE *fpt;

main()
{
 char c1;
  printf("\n\n\n\n\n\n\n\n\n\n");
  printf(" ---------------------------------------------------------------------------\n");
  printf("   Software code accompanying the book \n\n");
  printf("   Digita Photoelasticity - Advanced Techniques and Applications \n\n");
  printf("   Author : Dr. K. Ramesh. \n\n");
  printf("   Publisher : Springer-Verlag Berlin-Heidelberg-New York-Tokyo.\n");
  printf(" ---------------------------------------------------------------------------");
  printf("\n\n\n\n\n\n");
  printf("Press any key to continue...\n");
  getch();
  for(i=0;i<=23;i++)
  printf("\n");
 fpt=fopen("frn.dat","w");
 printf("\t              WORK FILE : ");
 scanf("%s",work_file_name);
 initialise_pip();
 printf("\n");
 printf("\t           Loading Workfile...                             \n");
 fg_frdisk(wbuf_size, 0, work_file_name, work_buf, current_seg);

 do{ printf("\nSelect point using '1'. Assign fringe order by 'f' and \n");
	 printf( "                             press ESC to trace :");
	 expanded_curs(); count = 0; i = p1x; j = p1y;
	 loop(); c1 = getch();
   } while( c1 != esc); fcloseall();
} //end of main 

track( int p, int q, int d)
 {
  value1 = fg_pixr(p,q);
  if( value1 >= 250) { i = p; j = q; fg_pixw(i,j,0);
		  fprintf(fpt,"%d %d %s\n",i,j,frn_buf); 
			status =1; tmpdir = d; }
  else { status =0; }
  return;
 } //end of track
scan_mask()
 {
  toarray(); 
  if(status == 0)   track(i,j-1,1); if(status == 0)   track(i,j+1,2);
  if(status == 0)   track(i-1,j,3); if(status == 0)   track(i+1,j,4);
  if(status == 0)   track(i-1,j-1,5); if(status == 0)   track(i+1,j-1,6);
  if(status == 0)   track(i-1,j+1,7); if(status == 0)   track(i+1,j+1,8);
 } //end of scan_mask

toarray()
 {
  int st1 = 0,tcount;
  tcount = count;
  st1=stor(i,j-1,st1); st1=stor(i,j+1,st1); st1=stor(i-1,j,st1);
  st1=stor(i+1,j,st1); st1=stor(i-1,j-1,st1); st1=stor(i+1,j-1,st1);
  st1=stor(i-1,j+1,st1); st1=stor(i+1,j+1,st1);
  if(count != tcount)
   { printf("\nOld points=%d  No of node points =%d ",tcount,count);}
 } //end of toarray

int stor(int i1,int j1,int st2)
 { // Stores all the branches other than the main fringe directions 
  unsigned long t ;
  t = fg_pixr(i1,j1); if( t >= 250)
			   { if(st2==1) { Si[count]=i1; Sj[count]=j1;
			  printf("\nIncrementing count :"); count +=1; }
			 else { st2=1; } }
  return(st2);} // end of stor

loop()
 {
  unsigned long val;
  fg_pixw(i,j,0);
	 fprintf(fpt,"%d %d %s\n",i,j,frn_buf); 

  do { status = 0; scan_mask();// If still not found then chk for discontinuity
	   if(status == 0)
	{ printf("\nDiscontinuity or the Endpoint encountered !!! ");
	  printf(" i = %d\tj = %d",i,j);
	  switch(tmpdir) {
			 case(1) : j=j-1; scan_mask(); break;
			 case(2) : j=j+1; scan_mask(); break;
			 case(3) : i=i-1; scan_mask(); break;
			 case(4) : i=i+1; scan_mask(); break;
			 case(5) : i=i-1; j=j-1;  scan_mask(); break;
			 case(6) : i=i+1; j=j-1;  scan_mask(); break;
			 case(7) : i=i-1; j=j+1;  scan_mask(); break;
			 case(8) : i=i+1; j=j+1;  scan_mask(); break;
			 } } // if status == 0 ends 
	 } while( status != 0);
  while(count >=0)
	{ count = count -1;
	  if( (val = fg_pixr(Si[count],Sj[count]) ) >= 250 && count >=0) 
	{ i = Si[count]; j = Sj[count]; loop(); } }
 } // end of loop 
