/* This program is skipping the point based on the improved phase map 
as calculated by 2dtile.c program for plane polariscope arrangements.  */

#include"curupip.h"
#define pi 3.141592653
#define TOLER 0.00001 
int delx,dely;
FILE *fpt;
main()
{ 
  int i,a,l,k,il,il1,il3,v[15],jj,val1,val2;
  float delta,Epsilon,Epsilon1,Angle,t1,t3,nr,dr;
  float theta,theta1,theta2,isoclinic;
  char work_buf[wbuf_size],first_file[40], second_file[40];
  char third_file[40],work_file_name[40],frn_file[40];
  char strbuf[10],out[60],*b,quit,save_file[40]; 
  printf("\n\n\n\n\n\n\n\n\n\n");
  printf(" ---------------------------------------------------------------------------\n");
  printf("   Software code accompanying the book \n\n");
  printf("   Digita Photoelasticity - Advanced Techniques and Applications \n\n");
  printf("   Author : Dr. K. Ramesh. \n\n");
  printf("   Publisher : Springer-Verlag Berlin-Heidelberg-New York-Tokyo.\n");
  printf(" ---------------------------------------------------------------------------");
  printf("\n\n\n\n\n\n");
  printf("Press any key to continue...\n");
  getch();
  for(i=0;i<=23;i++)
  printf("\n");
  printf("\n\t Work file (without extension): ");
  scanf("%s",work_file_name);
  strcpy(first_file,work_file_name);
  strcat(work_file_name,".p0");
  strcpy(out,work_file_name);
  strcat(first_file,".phs");
  for(i=2;i<=3;i++)
   {
	 strcpy(work_file_name,out);
	 b=itoa(i,strbuf,10);
	 strcat(work_file_name,b);
	 if(i==2) strcpy(second_file,work_file_name);
	 if(i==3) strcpy(third_file,work_file_name);
   }
  
  printf("\n\t Save output image as : ");
  scanf("%s",save_file);
  printf("\n\t Give fringe order tolerance .... : ");
  scanf("%f",&Epsilon);
  printf("\t Give isoclinic fringe tolerance (deg).... : ");
  scanf("%f",&Epsilon1);
  
  Epsilon=Epsilon*2.0*pi;
  Epsilon1 = Epsilon1*pi/180.0; 
  
  initialise_pip();
  quad2=0;
  fg_dquad(quad2 %=4); 
  fg_dquad(0);
  qd2.x=(quad2/2)*512;
  qd2.y=(quad2%2)*512;
  fg_dquad(0);
  fg_clear(0,0);
  fg_dquad(1);
  fg_clear(1,1);
  fg_dquad(2);
  fg_clear(2,2);
  fg_dquad(3);
  fg_clear(3,3);
  fg_setind(255);
  
  fg_dquad(0);
  fg_frdisk(wbuf_size,0,first_file,work_buf,current_seg);
  window_cursor();
  fg_frdisk(wbuf_size,0,first_file,work_buf,current_seg);
  fg_dquad(1);
  fg_frdisk(wbuf_size,1,second_file,work_buf,current_seg);
  fg_dquad(2);
  fg_frdisk(wbuf_size,2,third_file,work_buf,current_seg);
  fg_dquad(3);

  for (l=winxy[1];l<=winxy[3];l++)
   {
	 for (k=winxy[0];k<=winxy[2];k++)
	   {
		 for (i=1;i<=12;i++)
		 {
		  ch_wa(i);
		  v[i]=fg_pixr(k+delx,l+dely);
		 }
	 
		 /* finding theta by plane polariscope arrangement */          
		if(v[12]==v[7])
		 { 
		  if(v[11] > v[10])
		   theta = pi/(double)8.0; 
		  else if (v[11] < v[10])
		   theta = -1.0*pi/(double)8.0;
		  else
		   theta=0.0;
		 }
		else
		 {
		  nr=(v[11] - v[10]);
		  dr=(v[12] - v[7]);
		  theta = 0.25*atan2(nr,dr); 
		 } /* ends here */
	
		/* finding delta by square-root phase-map */
		delta=(v[1]*2.0*pi)/255.0;
	 
		/*isoclinic drawing module */ 
		t1=delta;
		t3=2.0*pi-delta;
	 
		if(t1 > Epsilon && t3 > Epsilon)
		 {
		  for(jj=-90;jj<=90;jj=jj+10) 
		   {
			 Angle=((float)jj)*pi/180.0; 
			 if(fabs(theta - Angle) <= Epsilon1)
			  {
				ch_wa(16);
				fg_pixw(k+delx,l+dely,255);
			  }
		   }    
		 }
	   }
   }
  fg_dquad(3);
  fg_todisk(wbuf_size,3,save_file,work_buf,current_seg);
  printf("\n\t Save the image as %s",save_file);
  printf("\n\n \tPi = %12.10f \n",pi);
}

ch_wa(wa)
int wa;
{
  if (wa <= 4)
		 {
		   /*fg_dquad(0);*/
		   qd2.x = 0;
		   qd2.y = 0;
		   delx  = ((wa-1)%2)*256;
		   dely  = ((wa-1)/2)*256;
		 }
   else if( wa>4 && wa <= 8)
		 {
		  /*fg_dquad(1);*/
		  qd2.x = 0;
		  qd2.y = 512;
		  delx  = ((wa-5)%2)*256;
		  dely  = ((wa-5)/2)*256+512;
		 }
   else if( wa>9 && wa <= 12)
		 {
		  /*fg_dquad(2);*/ 
		   qd2.x = 512;
		   qd2.y = 0;
		   delx  = ((wa-9)%2)*256+512;
		   dely  = ((wa-9)/2)*256;
		 }
   else    {
		  /*fg_dquad(3);*/
		  qd2.x = 512;
		  qd2.y = 512;
		  delx  = ((wa-13)%2)*256 +512;
		  dely  = ((wa-13)/2)*256 +512;
	   }
}
