/* Final program to edit ths phase-map based on continuity and tiling 
concept. */

#include"curupip.h"
#define pi (double)3.141592653
#define TOLER 0.0001

int delx,dely;
int i,a,l,k,il,v[7],il1,s_choice,p_choice,il2;
int c_flag,l_flag,flag,s_flag,temp,frn_choice;
double delta,deltasqrtp,deltasqrtn,l_value,theta,start_pt,tt1;
double nr,dr,value,slope1,slope2;

m_init_pip()  
{  
  fg_inifmt(620,1,0,0,1,0);
  fg_chan(0);
  fg_quadm(1);
  fg_pan(0);
  fg_scroll(0);
  fg_zoom(0);
  fg_iniluts(0);
  fg_setwin(0,0,511,511);
  quad2=0;
  fg_dquad(quad2 %=4);
  qd2.x=(quad2/2) *512;
  qd2.y=(quad2%2) *512;
  fg_dquad(0);
}
pixel_read()            
{
  for (i=1;i<=6;i++)
   {
	  ch_wa(i);
	  v[i]=fg_pixr(k+delx,l+dely);
   }
}
square_root()         
{
	 /* the  +ve square root formula */
	 nr=sqrt((double)((v[5]-v[3])*(v[5]-v[3])+(v[4]-v[6])*(v[4]-v[6])));
	 dr=(double)(v[1]-v[2]);
	 if(v[1]==v[2])
		deltasqrtp=pi/(double)2.0;
	 else
		deltasqrtp=atan2(nr,dr);
	 /* ends here. */

	 /* the  -ve square root formula */
	 nr=sqrt((double)((v[5]-v[3])*(v[5]-v[3])+(v[4]-v[6])*(v[4]-v[6])));
	 nr=-1.0*nr;
	 dr=(double)(v[1]-v[2]);
	 if(v[1]==v[2])
		deltasqrtn=-1.0*pi/(double)2.0;
	 else
		deltasqrtn=atan2(nr,dr);
	 /* ends here. */

	 if (deltasqrtn < 0) deltasqrtn = deltasqrtn + 2.0*pi; 
	 if (deltasqrtp < 0) deltasqrtp = deltasqrtp + 2.0*pi; 
}            
frn_ascend()         
{
	 if(c_flag == 1 && l_flag == 1)
	   {
		   printf("\n\t +ve square root result is %8.5lf",deltasqrtp/(2.0*pi));
		   printf("\n\t -ve square root result is %8.5lf",deltasqrtn/(2.0*pi));
		   printf("\n\t choose any one of above type 1 for +ve square root");
		   printf("\n\t 2 for -ve square root ");
		   scanf("%d",&s_choice);
		   if(s_choice==1) delta=deltasqrtp;
		   if(s_choice==2) delta=deltasqrtn;
		   value=delta/(2.0*pi);
		   l_value=delta/(2.0*pi);
		   start_pt=delta/(2.0*pi);
		   flag=flag+1;
	   }
	 else if (flag == 1)  
	   {
		value=l_value; 
		slope1=deltasqrtp/(2.0*pi) - value;
		slope2=deltasqrtn/(2.0*pi) - value;
		if(slope1 < slope2 && slope1 > TOLER && slope2 > TOLER )
		  delta = deltasqrtp;
		else if(slope1 < TOLER && slope2 > TOLER )
		  delta = deltasqrtn;
		/*else if(slope1 < TOLER && slope2 < TOLER )*/
		else 
		  delta = deltasqrtp;
		value=delta/(2.0*pi);
		l_value=delta/(2.0*pi);
	   }
	 else
	   {
		   slope1=deltasqrtp/(2.0*pi) - value;
		   slope2=deltasqrtn/(2.0*pi) - value;
		   if(slope1 < slope2 && slope1 > TOLER && slope2 > TOLER )
		  delta = deltasqrtp;
		   else if(slope1 < TOLER && slope2 > TOLER )
		  delta = deltasqrtn;
		   /* else if(slope1 < TOLER && slope2 < TOLER ) */
		   else
		  delta = deltasqrtp;
		   value=delta/(2.0*pi);
	   }
}

frn_decend()         
{
	 if(c_flag == 1 && l_flag == 1)
	   {
		   printf("\n\t +ve square root result is %8.5lf",deltasqrtp/(2.0*pi));
		   printf("\n\t -ve square root result is %8.5lf",deltasqrtn/(2.0*pi));
		   printf("\n\t choose any one of above type 1 for +ve square root");
		   printf("\n\t 2 for -ve square root ");
		   scanf("%d",&s_choice);
		   if(s_choice==1) delta=deltasqrtp;
		   if(s_choice==2) delta=deltasqrtn;
		   value=delta/(2.0*pi);
		   l_value=delta/(2.0*pi);
		   start_pt=delta/(2.0*pi);
		   flag=flag+1;
	   }
	 else if (flag == 1)  
	   {
		value=l_value; 
		slope1=deltasqrtp/(2.0*pi) - value;
		slope2=deltasqrtn/(2.0*pi) - value;
		if(slope1 < slope2 && slope1 < TOLER && slope2 < TOLER )
		  delta = deltasqrtn;
		else if(slope1 < TOLER && slope2 > TOLER )
		  delta = deltasqrtp;
		/*else if(slope1 < TOLER && slope2 < TOLER )*/
		else 
		  delta = deltasqrtn;
		value=delta/(2.0*pi);
		l_value=delta/(2.0*pi);
	   }
	 else
	   {
		   slope1=deltasqrtp/(2.0*pi) - value;
		   slope2=deltasqrtn/(2.0*pi) - value;
		if(slope1 < slope2 && slope1 < TOLER && slope2 < TOLER )
		  delta = deltasqrtn;
		else if(slope1 < TOLER && slope2 > TOLER )
		  delta = deltasqrtp;
		/*else if(slope1 < TOLER && slope2 < TOLER )*/
		else 
		  delta = deltasqrtn;
		value=delta/(2.0*pi);
	   }
}
phase_quirga()
{
		/* finding theta by circular arrangement */          
		if (v[4]==v[6])
		 { 
		  if (v[5] > v[3])
		   theta=pi/(double)4.0;
		  else 
		   theta=-pi/(double)4.0;
		 }
		else
		{
		 nr=(v[5] - v[3]);
		 dr=(v[4] - v[6]);
		 theta = 0.5*atan(nr/dr);
		}
		/* ends here */

		/* implementing Quiroga equation */         
		nr=(v[5]-v[3])*sin(2*theta)+(v[4]-v[6])*cos(2*theta);
		dr=(double)(v[1]-v[2]);
		if( (fabs)(dr) < TOLER && nr > TOLER)
		   delta=pi/(double)2.0;
		else if( (fabs)(dr) < TOLER && nr < TOLER)
		   delta=-1.0*pi/(double)2.0;
		else 
		  delta=atan2(nr,dr);
}
intensity_assign()         
{
   tt1=(delta*255.0)/(2.0*pi);
   il2=(delta*255.0)/(2.0*pi);
   if((tt1-il2)  > 0.5 ) 
	   il=il2+1;
   else
	   il=il2;
}

main()
{ 
  char work_buf[wbuf_size],first_file[60],second_file[60],save_file[60];
  char strbuf[10],out[60],*b,work_file_name[60];
  int xindex,yindex;
  char sw_choice,sat_choice,ow_choice,r_choice,change_choice;
  printf("\n\n\n\n\n\n\n\n\n\n");
  printf(" ---------------------------------------------------------------------------\n");
  printf("   Software code accompanying the book \n\n");
  printf("   Digita Photoelasticity - Advanced Techniques and Applications \n\n");
  printf("   Author : Dr. K. Ramesh. \n\n");
  printf("   Publisher : Springer-Verlag Berlin-Heidelberg-New York-Tokyo.\n");
  printf(" ---------------------------------------------------------------------------");
  printf("\n\n\n\n\n\n");
  printf("Press any key to continue...\n");
  getch();
  for(i=0;i<=23;i++)
  printf("\n");
  sat_choice='Y';
  r_choice='Y';
  sw_choice='N';
  ow_choice='N';
  s_flag=1;

  printf("\n\t work file (without extension): ");
  scanf("%s",work_file_name);
  strcat(work_file_name,".p0");
  strcpy(out,work_file_name);
  for(i=1;i<=2;i++)
   {
	 strcpy(work_file_name,out);
	 b=itoa(i,strbuf,10);
	 strcat(work_file_name,b);
	 if(i==1) strcpy(first_file,work_file_name);
	 if(i==2) strcpy(second_file,work_file_name);
   }
  
  printf("\n\t Output image file to be saved as : ");
  scanf("%s",save_file);
  
  printf("\n\t Do not press Enter only type the required alphabet ");
  printf("\n\t Do you want to overwrite the phase-maps [y/n] : ");
  ow_choice=getche();
  ow_choice=toupper(ow_choice);

  m_init_pip();  
  fg_dquad(3);
  fg_clear(3,3);
  fg_setind(255);
   
  while(r_choice =='Y')
  {
	if(s_flag==1)
	 {
	  fg_dquad(0);
	  fg_frdisk(wbuf_size,0,first_file,work_buf,current_seg);
	  window_cursor();
	 }
	else if((s_flag > 1) && (sat_choice == 'Y'))
	 {
	  m_init_pip();  
	  fg_dquad(0);
	  fg_frdisk(wbuf_size,0,save_file,work_buf,current_seg);
	  window_cursor();
	 }
	else
	 {
	  m_init_pip();  
	  fg_dquad(3);
	  ch_wa(13);
	  fg_rect(winxy[0]+delx-1,winxy[1]+dely-1,delx+winxy[2]+1,dely+winxy[3]+1);
	  printf("\n\t Previous window is  %4d  %4d  %4d  %4d",winxy[0],winxy[1],winxy[2],winxy[3]);
	  printf("\n\t Do not press Enter only type the required alphabet ");
	  printf("\n\t Do you want to change the window [y/n] : ");
	  change_choice=getche();
	  change_choice=toupper(change_choice);
	  if(change_choice == 'Y')
	  {
	m_init_pip();  
	fg_dquad(0);
	fg_frdisk(wbuf_size,0,save_file,work_buf,current_seg);
	window_cursor();
	  }
	  printf("\n\t Previous choices in the same sequence are "); 
	  printf("\n\t %3d %3d %8.5lf",p_choice,frn_choice,start_pt);
	  printf("\n\t If you change the 1st choice then 3rd choice beomes useless"); 
	  fg_frdisk(wbuf_size,3,save_file,work_buf,current_seg);
	 }
	
	fg_frdisk(wbuf_size,0,first_file,work_buf,current_seg);
	fg_frdisk(wbuf_size,1,second_file,work_buf,current_seg);
	
	for (i=1;i<=6;++i)
	 {
	  ch_wa(i);
	  fg_rect(winxy[0]+delx-1,winxy[1]+dely-1,delx+winxy[2]+1,dely+winxy[3]+1);
	 }
	
	fg_dquad(3);
	 
	printf("\n\n\t Enter your chioce ");
	printf("\n\t 1 for L to R continuity guess at the left top most point");
	printf("\n\t 2 for R to L continuity guess at the right bottom most point"); 
	printf("\n\t 3 for T to B continuity guess at the left top most point"); 
	printf("\n\t 4 for B to T continuity guess at the right bottom most point"); 
	printf("\n\t 5 for diogonal down continuity guess at right top most point");
	printf("\n\t 6 for diogonal down continuity guess at left top most point");
	printf("\n\t 7 for diogonal up continuity guess at right bottom most point");
	printf("\n\t 8 for diogonal up continuity guess at left bottom most point");
	printf("\n\t 9 same as 5 but upto diogonal line ");
	printf("\n\t 10 same as 6 but upto diogonal line ");
	printf("\n\t 11 same as 7 but upto diogonal line ");
	printf("\n\t 12 same as 8 but upto diogonal line ");
	printf("\n\t 13 for using cos+sin expressioin :  ");
	scanf("%d",&p_choice);
	
	if(p_choice < 13)
	 {
	  printf("\t Enter your choice of fringe gradient");
	  printf("\n\t Type 1 when partial fringe order increases ");
	  printf("\n\t 2 when partial fringe order decreases : ");
	  scanf("%d",&frn_choice);
	 }
	c_flag=1;
	l_flag=1;
	
	if((s_flag > 1) && (sat_choice == 'N'))
	  fg_frdisk(wbuf_size,3,save_file,work_buf,current_seg);
	 

	switch (p_choice)   
	 {
	  
	  case 1 :
	printf("\t L to R continuity guess at the left top most point");
	for (l=winxy[1];l<=winxy[3];l++)
	 {
	   flag=1;
	   for (k=winxy[0];k<=winxy[2];k++)
		{
		  pixel_read();            
		  square_root();
		  if(frn_choice == 1) frn_ascend();   
		  if(frn_choice == 2) frn_decend();   
	 
		  /* phase map drawing module */
		  intensity_assign();         
		  /*il = delta*255.0/(2.0*pi);*/
		  ch_wa(13);  
		  fg_pixw(k+delx,l+dely,il);

		  l_flag=l_flag+1;
		  c_flag=c_flag+1;
		} 
	 }
	break;
	  
	  case 2 :
	
	printf("\t R to L continuity guess at the right bottom most point"); 
	for (l=winxy[3];l>=winxy[1];l--)
	 {
	  flag=1;
	  for (k=winxy[2];k>=winxy[0];k--)
	   {
		  pixel_read();            
		  square_root();
		  if(frn_choice == 1) frn_ascend();   
		  if(frn_choice == 2) frn_decend();   
	 
		  /* phase map drawing module */
		  intensity_assign();         
		  /*il = delta*255.0/(2.0*pi);*/
		  if(ow_choice == 'Y') ch_wa(13);  
		  if(ow_choice == 'N') ch_wa(14);  
		  fg_pixw(k+delx,l+dely,il);

		  l_flag=l_flag+1;
		  c_flag=c_flag+1;
		} 
	 }
	break;
   
	  case 3:
	 
	printf("\t T to B continuity guess at the left top most point"); 
	for (k=winxy[0];k<=winxy[2];k++)
	 {
	  flag=1;
	  for (l=winxy[1];l<=winxy[3];l++)
	   {
		pixel_read();            
		square_root();
		if(frn_choice == 1) frn_ascend();   
		if(frn_choice == 2) frn_decend();   
		 
		/* phase map drawing module */
		intensity_assign();         
		/*il = delta*255.0/(2.0*pi);*/
		if(ow_choice == 'Y') ch_wa(13);  
		if(ow_choice == 'N') ch_wa(15);  
		fg_pixw(k+delx,l+dely,il);

		l_flag=l_flag+1;
		c_flag=c_flag+1;
	   } 
	 }
	break;

	  case 4 :
	 
	printf("\n\t B to T continuity guess at the right bottom most point"); 
	for (k=winxy[2];k>=winxy[0];k--)
	 {
	  flag=1;
	  for (l=winxy[3];l>=winxy[1];l--)
	   {
		pixel_read();
		square_root();
		if(frn_choice == 1) frn_ascend();   
		if(frn_choice == 2) frn_decend();   
	 
		/* phase map drawing module */
		intensity_assign();         
		/*il = delta*255.0/(2.0*pi);*/
		if(ow_choice == 'Y') ch_wa(13);  
		if(ow_choice == 'N') ch_wa(16);  
		fg_pixw(k+delx,l+dely,il);

		l_flag=l_flag+1;
		c_flag=c_flag+1;
	   } 
	 }
	break;
	 
	  case 5:

	printf("\t diogonal down continuity guess at right top most point");
	flag=1;
	 
	for (xindex = winxy[2];xindex >= winxy[0]; xindex--)  
	  for(k=xindex,l=winxy[1];((k < winxy[2]+1) && (l < winxy[3]+1));k++,l++) 
	   {
		pixel_read();
		square_root();
		if(frn_choice == 1) frn_ascend();   
		if(frn_choice == 2) frn_decend();   
	 
		/* phase map drawing module */
		intensity_assign();         
		/*il = delta*255.0/(2.0*pi);*/
		ch_wa(13);  
		fg_pixw(k+delx,l+dely,il);

		l_flag=l_flag+1;
		c_flag=c_flag+1;
	   }      
	 
	for (yindex = winxy[1];yindex < winxy[3]+1; ++yindex)  
	  for(k=winxy[0],l=yindex;((k < winxy[2]+1) && (l < winxy[3]+1));k++,l++) 
	   {
		for (i=1;i<=6;i++)
		 {
		  ch_wa(i);
		  v[i]=fg_pixr(k+delx,l+dely);
		 }
		
		square_root();
		if(frn_choice == 1) frn_ascend();   
		if(frn_choice == 2) frn_decend();   
	 
		/* phase map drawing module */
		intensity_assign();         
		/*il = delta*255.0/(2.0*pi);*/
		ch_wa(13);  
		fg_pixw(k+delx,l+dely,il);

		l_flag=l_flag+1;
		c_flag=c_flag+1;
	   }
	break;

	  case 6:
	
	printf("\t diogonal down continuity guess at left top most point");
	flag=1;
	for (xindex = winxy[0];xindex <= winxy[2]; xindex++)  
	  for(k=xindex,l=winxy[1];((k > winxy[0]-1) && (l < winxy[3]+1));k--,l++) 
	   {
		pixel_read();            
		square_root();
		if(frn_choice == 1) frn_ascend();   
		if(frn_choice == 2) frn_decend();   
	 
		/* phase map drawing module */
		intensity_assign();         
		/*il = delta*255.0/(2.0*pi);*/
		if(ow_choice == 'Y') ch_wa(13);  
		if(ow_choice == 'N') ch_wa(14);  
		fg_pixw(k+delx,l+dely,il);

		l_flag=l_flag+1;
		c_flag=c_flag+1;
	   }      
	  
	for (yindex = winxy[1];yindex < winxy[3]+1; ++yindex)  
	  for(k=winxy[2],l=yindex;((k > winxy[0]-1) && (l < winxy[3]+1));k--,l++) 
	   {
		for (i=1;i<=6;i++)
		 {
		  ch_wa(i);
		  v[i]=fg_pixr(k+delx,l+dely);
		 }
	   
		square_root();
		if(frn_choice == 1) frn_ascend();   
		if(frn_choice == 2) frn_decend();   
	 
		/* phase map drawing module */
		intensity_assign();         
		/*il = delta*255.0/(2.0*pi);*/
		if(ow_choice == 'Y') ch_wa(13);  
		if(ow_choice == 'N') ch_wa(14); 
		fg_pixw(k+delx,l+dely,il);

		l_flag=l_flag+1;
		c_flag=c_flag+1;
	   } 
	break;

	  case 7:

	printf("\t diogonal up continuity guess at right bottom most point");
	flag=1;
	for (xindex = winxy[2];xindex >= winxy[0]; xindex--)  
	  for(k=xindex,l=winxy[3];((k < winxy[2]+1) && (l > winxy[1]-1));k++,l--) 
	   {
		pixel_read();            
		square_root();
		if(frn_choice == 1) frn_ascend();   
		if(frn_choice == 2) frn_decend();   
	 
		/* phase map drawing module */
		intensity_assign();         
		/*il = delta*255.0/(2.0*pi);*/
		if(ow_choice == 'Y') ch_wa(13);  
		if(ow_choice == 'N') ch_wa(15);  
		fg_pixw(k+delx,l+dely,il);

		l_flag=l_flag+1;
		c_flag=c_flag+1;
	   }
	 
	for (yindex = winxy[3];yindex > winxy[1]-1; --yindex)  
	  for(k=winxy[0],l=yindex;((k < winxy[2]+1) && (l > winxy[1]-1));k++,l--) 
		{
		 for (i=1;i<=6;i++)
		  {
		   ch_wa(i);
		   v[i]=fg_pixr(k+delx,l+dely);
		  }
	  
		 square_root();
		 if(frn_choice == 1) frn_ascend();   
		 if(frn_choice == 2) frn_decend();   
	 
		 /* phase map drawing module */
		 intensity_assign();         
		 /*il = delta*255.0/(2.0*pi);*/
		 if(ow_choice == 'Y') ch_wa(13);  
		 if(ow_choice == 'N') ch_wa(15);  
		 fg_pixw(k+delx,l+dely,il);

		 l_flag=l_flag+1;
		 c_flag=c_flag+1;
		}
	break;

	  case 8:
	
	printf("\t diogonal up continuity guess at left bottom most point");
	flag=1;
	for (xindex = winxy[0];xindex <= winxy[2]; xindex++)  
	  for(k=xindex,l=winxy[3];((k > winxy[0]-1) && (l > winxy[1]-1));--k,--l) 
	   {
		pixel_read();            
		square_root();
		if(frn_choice == 1) frn_ascend();   
		if(frn_choice == 2) frn_decend();   
	 
		/* phase map drawing module */
		intensity_assign();         
		/*il = delta*255.0/(2.0*pi);*/
		if(ow_choice == 'Y') ch_wa(13);  
		if(ow_choice == 'N') ch_wa(16);  
		fg_pixw(k+delx,l+dely,il);

		l_flag=l_flag+1;
		c_flag=c_flag+1;
	   }      
	for (yindex = winxy[3];yindex > winxy[1]-1; --yindex)  
	  for(k=winxy[2],l=yindex;((k > winxy[0]-1) && (l > winxy[1]-1));--k,--l) 
	   {
		for (i=1;i<=6;i++)
		 {
		  ch_wa(i);
		  v[i]=fg_pixr(k+delx,l+dely);
		 }
	  
		square_root();
		if(frn_choice == 1) frn_ascend();   
		if(frn_choice == 2) frn_decend();   
	 
		/* phase map drawing module */
		intensity_assign();         
		/*il = delta*255.0/(2.0*pi);*/
		if(ow_choice == 'Y') ch_wa(13);  
		if(ow_choice == 'N') ch_wa(16);  
		fg_pixw(k+delx,l+dely,il);

		l_flag=l_flag+1;
		c_flag=c_flag+1;
	   }
	break;

	  case 9:

	printf("\t Same as 5 but upto diogonal line ");
	flag=1;
	 
	for (xindex = winxy[2];xindex >= winxy[0]; xindex--)  
	  for(k=xindex,l=winxy[1];((l < winxy[2]+winxy[1]-k+1) && (l < winxy[3]+1));k++,l++) 
	   { 
		pixel_read();            
		square_root();
		if(frn_choice == 1) frn_ascend();   
		if(frn_choice == 2) frn_decend();   
	 
		/* phase map drawing module */
		intensity_assign();         
		/*il = delta*255.0/(2.0*pi);*/
		ch_wa(13);  
		fg_pixw(k+delx,l+dely,il);

		l_flag=l_flag+1;
		c_flag=c_flag+1;
	   }      
	 
	for (yindex = winxy[1];yindex < winxy[3]+1; ++yindex)  
	  for(k=winxy[0],l=yindex;((l < winxy[2]+winxy[1]-k+1) && (l < winxy[3]+1));k++,l++) 
	   {
		for (i=1;i<=6;i++)
		 {
		  ch_wa(i);
		  v[i]=fg_pixr(k+delx,l+dely);
		 }
		
		square_root();
		if(frn_choice == 1) frn_ascend();   
		if(frn_choice == 2) frn_decend();   
	 
		/* phase map drawing module */
		intensity_assign();         
		/*il = delta*255.0/(2.0*pi);*/
		ch_wa(13);  
		fg_pixw(k+delx,l+dely,il);

		l_flag=l_flag+1;
		c_flag=c_flag+1;
	   }
	break;

	  case 10:
	
	printf("\t Same as 6 but upto diogonal line ");
	flag=1;
	for (xindex = winxy[0];xindex <= winxy[2]; xindex++)  
	  for(k=xindex,l=winxy[1]; ((l < k-winxy[0]+winxy[1]+1)&& (l < winxy[3]+1));k--,l++) 
	   {
		pixel_read();            
		square_root();
		if(frn_choice == 1) frn_ascend();   
		if(frn_choice == 2) frn_decend();   
	 
		/* phase map drawing module */
		intensity_assign();         
		/*il = delta*255.0/(2.0*pi);*/
		if(ow_choice == 'Y') ch_wa(13);  
		if(ow_choice == 'N') ch_wa(14);  
		fg_pixw(k+delx,l+dely,il);

		l_flag=l_flag+1;
		c_flag=c_flag+1;
	   }      
	  
	for (yindex = winxy[1];yindex < winxy[3]+1; ++yindex)  
	  for(k=winxy[2],l=yindex; ((l < k-winxy[0]+winxy[1]+1)&& (l < winxy[3]+1));k--,l++) 
	   {
		for (i=1;i<=6;i++)
		 {
		  ch_wa(i);
		  v[i]=fg_pixr(k+delx,l+dely);
		 }
	   
		square_root();
		if(frn_choice == 1) frn_ascend();   
		if(frn_choice == 2) frn_decend();   
	 
		/* phase map drawing module */
		intensity_assign();         
		/*il = delta*255.0/(2.0*pi);*/
		if(ow_choice == 'Y') ch_wa(13);  
		if(ow_choice == 'N') ch_wa(14); 
		fg_pixw(k+delx,l+dely,il);

		l_flag=l_flag+1;
		c_flag=c_flag+1;
	   } 
	break;

	  case 11:

	printf("\t Same as 7 but upto diogonal line ");
	flag=1;
	for (xindex = winxy[2];xindex >= winxy[0]; xindex--)  
	  for(k=xindex,l=winxy[3]; ((l > k-winxy[2]+winxy[3]-1)&& (l > winxy[1]-1));k++,l--) 
	   {
		pixel_read();            
		square_root();
		if(frn_choice == 1) frn_ascend();   
		if(frn_choice == 2) frn_decend();   
	 
		/* phase map drawing module */
		intensity_assign();         
		/*il = delta*255.0/(2.0*pi);*/
		if(ow_choice == 'Y') ch_wa(13);  
		if(ow_choice == 'N') ch_wa(15);  
		fg_pixw(k+delx,l+dely,il);

		l_flag=l_flag+1;
		c_flag=c_flag+1;
	   }
	 
	for (yindex = winxy[3];yindex > winxy[1]-1; --yindex)  
	  for(k=winxy[0],l=yindex; ((l > k-winxy[2]+winxy[3]-1)&& (l > winxy[1]-1));k++,l--) 
		{
		 for (i=1;i<=6;i++)
		  {
		   ch_wa(i);
		   v[i]=fg_pixr(k+delx,l+dely);
		  }
	  
		 square_root();
		 if(frn_choice == 1) frn_ascend();   
		 if(frn_choice == 2) frn_decend();   
	 
		 /* phase map drawing module */
		 intensity_assign();         
		 /*il = delta*255.0/(2.0*pi);*/
		 if(ow_choice == 'Y') ch_wa(13);  
		 if(ow_choice == 'N') ch_wa(15);  
		 fg_pixw(k+delx,l+dely,il);

		 l_flag=l_flag+1;
		 c_flag=c_flag+1;
		}
	break;

	  case 12:
	
	printf("\t Same as 8 but upto diogonal line ");
	flag=1;
	for (xindex = winxy[0];xindex <= winxy[2]; xindex++)  
	  for(k=xindex,l=winxy[3];((l > winxy[0]+winxy[3]-k-1) && (l > winxy[1]-1));--k,--l) 
	   {
		pixel_read();            
		square_root();
		if(frn_choice == 1) frn_ascend();   
		if(frn_choice == 2) frn_decend();   
	 
		/* phase map drawing module */
		intensity_assign();         
		/*il = delta*255.0/(2.0*pi);*/
		if(ow_choice == 'Y') ch_wa(13);  
		if(ow_choice == 'N') ch_wa(16);  
		fg_pixw(k+delx,l+dely,il);

		l_flag=l_flag+1;
		c_flag=c_flag+1;
	   }      
	for (yindex = winxy[3];yindex > winxy[1]-1; --yindex)  
	  for(k=winxy[2],l=yindex;((l > winxy[0]+winxy[3]-k-1) && (l > winxy[1]-1));--k,--l) 
	   {
		for (i=1;i<=6;i++)
		 {
		  ch_wa(i);
		  v[i]=fg_pixr(k+delx,l+dely);
		 }
	  
		square_root();
		if(frn_choice == 1) frn_ascend();   
		if(frn_choice == 2) frn_decend();   
	 
		/* phase map drawing module */
		intensity_assign();         
		/*il = delta*255.0/(2.0*pi);*/
		if(ow_choice == 'Y') ch_wa(13);  
		if(ow_choice == 'N') ch_wa(16);  
		fg_pixw(k+delx,l+dely,il);

		l_flag=l_flag+1;
		c_flag=c_flag+1;
	   }
	break;
	  
	  case 13 :
	
	printf("\t Using cos+sin expressioin : ");
	printf("\n\t Do not press Enter only type the required alphabet ");
	printf("\n\t Do you want to swap the images [y/n] : ");
	sw_choice=getche();
	sw_choice=toupper(sw_choice);

	for (l=winxy[1];l<=winxy[3];l++)
	 {
	  for (k=winxy[0];k<=winxy[2];k++)
	   {
		pixel_read();            
		
		if (sw_choice == 'Y')
		 { 
		  temp=v[3]; v[3]=v[5]; v[5]=temp;
		  temp=v[4]; v[4]=v[6]; v[6]=temp;
		 }
	  
		phase_quirga();
		
		/* dark field drawing module */ 
		il1 = fabs(delta)*255.0/pi;
		ch_wa(14);  
		fg_pixw(k+delx,l+dely,il1);

		if (delta < 0) delta = delta + 2.0*pi; 

		/* phase map drawing module */
		intensity_assign();         
		/*il = delta*255.0/(2.0*pi);*/
		ch_wa(13);  
		fg_pixw(k+delx,l+dely,il);
	   } 
	 }  
	break;  
	 }
   s_flag=s_flag+1;
   printf("\n\t Do not press Enter only type the required alphabet ");
   printf("\n\t Are you satisfied with the modification [y/n] : ");
   sat_choice=getche();
   sat_choice=toupper(sat_choice);
   if (sat_choice == 'Y') 
	{   
	 printf("\n\t Please wait Disk is interacting.....");
	 fg_todisk(wbuf_size,3,save_file,work_buf,current_seg);
	 printf("\n\t Do not press Enter only type the required alphabet ");
	 printf("\n\t Do you want more processing of the phase-map [y/n] : ");
	 r_choice=getche();
	 r_choice=toupper(r_choice);
	}
   else
	 r_choice='Y';
  }
  printf("\n\t Please wait Disk is interacting.....");
  m_init_pip();  
  fg_todisk(wbuf_size,3,save_file,work_buf,current_seg);
  printf("\n\t Image saved as %s",save_file);
}

ch_wa(wa)
int wa;
{
  if (wa <= 4)
		 {
		   /*fg_dquad(0);*/
		   qd2.x = 0;
		   qd2.y = 0;
		   delx  = ((wa-1)%2)*256;
		   dely  = ((wa-1)/2)*256;
		 }
   else if( wa>4 && wa <= 8)
		 {
		  /*fg_dquad(1);*/
		  qd2.x = 0;
		  qd2.y = 512;
		  delx  = ((wa-5)%2)*256;
		  dely  = ((wa-5)/2)*256+512;
		 }
   else if( wa>9 && wa <= 12)
		 {
		  /*fg_dquad(2);*/ 
		   qd2.x = 512;
		   qd2.y = 0;
		   delx  = ((wa-9)%2)*256+512;
		   dely  = ((wa-9)/2)*256;
		 }
   else    {
		  /*fg_dquad(3);*/
		  qd2.x = 512;
		  qd2.y = 512;
		  delx  = ((wa-13)%2)*256 +512;
		  dely  = ((wa-13)/2)*256 +512;
	   }
}
