/********************************************************/
/*     NOISE REMOVAL OF THE PHASE MAP                   */
/********************************************************/

#include "curupip.h"
void main(void)
{
	char work_buf[wbuf_size];
	char input_file[30],image_file[30],out_file[30];
	int i;
	printf("\n\n\n\n\n\n\n\n\n\n");
	printf(" ---------------------------------------------------------------------------\n");
	printf("   Software code accompanying the book \n\n");
	printf("   Digita Photoelasticity - Advanced Techniques and Applications \n\n");
	printf("   Author : Dr. K. Ramesh. \n\n");
	printf("   Publisher : Springer-Verlag Berlin-Heidelberg-New York-Tokyo.\n");
	printf(" ---------------------------------------------------------------------------");
	printf("\n\n\n\n\n\n");
	printf("Press any key to continue...\n");
	getch();
	for(i=0;i<=23;i++)
	printf("\n");
	
	printf("\n \t \t Image file name (without extension) : ");
	scanf("%s",input_file);
	strcpy(image_file,input_file);
	strcat(image_file,".phs");
	initialise_pip();
	fg_frdisk(wbuf_size,quad2 %=4,image_file,work_buf,current_seg);
	window_cursor();
	noise_removal();
	printf("\n Output file Name(with extension):");
	scanf("%s",out_file);
	fflush(stdin);
	fg_todisk(wbuf_size,quad2 %=4,out_file,work_buf,current_seg);
	for(i=0;i<25;i++) printf("\n");
	printf(" Image is stored as %s",out_file);
}
/* End of main prog */


noise_removal()
{
	int i,j,inten;
	float slope1,slope2;
	for(j=winxy[1];j<=winxy[3];j++)
	{
		for(i=winxy[0];i<=winxy[2];i++)
		{
			slope1=fg_pixr(i,j)-fg_pixr(i-1,j);
			slope2=fg_pixr(i+1,j)-fg_pixr(i,j);
	   if((slope1>100 && slope2<-100) || (slope1<-100 && slope2>100))
			{      
				inten=(fg_pixr(i-1,j)+fg_pixr(i+1,j))/2.0;
				fg_pixw(i,j,inten);
			}
			slope1=fg_pixr(i,j)-fg_pixr(i,j-1);
			slope2=fg_pixr(i,j+1)-fg_pixr(i,j);
	   if((slope1>100 && slope2<-100) || (slope1<-100 && slope2>100))
			{      
				inten=(fg_pixr(i,j-1)+fg_pixr(i,j+1))/2.0;
				fg_pixw(i,j,inten);
			}
			slope1=fg_pixr(i,j)-fg_pixr(i-1,j-1);
			slope2=fg_pixr(i+1,j+1)-fg_pixr(i,j);
	   if((slope1>100 && slope2<-100) || (slope1<-100 && slope2>100))
			{      
				inten=(fg_pixr(i-1,j-1)+fg_pixr(i+1,j+1))/2.0;
				fg_pixw(i,j,inten);
			}

		}
	}
}

