//
// dart.cc
//
// Dart-Board-Algorithm for approximating pi
//

#include <iostream.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

int
main(int argc, char **argv)
{
   long   k, n, hits;
   const double factor = 1.0 / RAND_MAX;

   do
   {
      // try cmdline
      if (argc > 1)
         n = atoi(argv[1]);
      else
      {
        // Get no of throws
        cout << "Enter the no of throws (or 0 to exit): ";
        cin >> n;
      }
      if ( n <= 0) // input <= 0 means end-of-job
         break;
      // Initialize the random generator
      // with a 'random' value; here = clock()
      srand((int)clock());

      // Throw n tosses
      for (k=hits=0; k < n; ++k)
      {
         // Find two random numbers within 0..1
         double x = rand() * factor;
         double y = rand() * factor;
         if (x*x + y*y < 1.0) /* Within circle ? */
            ++hits;           /* yes: hits += 1  */
      }
      double pi_approx = 4.0 * hits / n;
      cout  << "Approximation of pi after "
            << n << " throws: " << pi_approx
            << " (relative error="
            << fabs(M_PI - pi_approx)*100/M_PI
            << "%)\n";
   } while (argc <= 1);
   return 0;
}


