//
// PIFILE.C
//
// Performs the operations
//        fopen_pi
//        fread_pi
//        fseek_pi
// for a set of pi files with only decimal ASCII digits
//
// Use standard fopen and fclose to open and close

#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include "myutils.h"    // prototypes of progexit()
#include "pifile.h"     // prototypes of fopen_pi(), fread_pi() and lseek_pi()

char  pidir[260] = "";  
int   cfgread = 0;
FILE  *fpcfg = NULL;    // fileptr to pifile.cfg 
char  line[270];
char  fn_pi[260];
char  *pi_filename_fmt = "%s/pi%02d.dat";
int   fno_pi    = -1;
int   fno_first = 1;
int   fno_last  = -1;
FILE  *fp_pi   = NULL;
long  fsize[FNO_MAX+1];
int   bStartsWith3 = 0;
long  lTrue; // -1 if a negative fseek would have been nec. in case
             // the first pi file does not start with 3

/* fopen_pi opens the pifile <fno> of the pi file set.
   (1 <= fno <= fno_last+1).
   If the file can be opened then
     fno_pi     := fno
     fp_pi      := stream
     fsize[fno] := file size
     fno_last   := max(fno_last, fno)
   otherwise
     fp_pi      := NULL
     fno_pi     := 0
   It returns fp_pi
*/


FILE *fopen_pi(int fno)
{
  if (cfgread == 0) {
    // Try pifile.cfg for a pidir= or PIDIR= specification
    FILE *fpcfg = fopen("pifile.cfg", "r");
    if (fpcfg) {
      fgets(line, sizeof(line), fpcfg);
      if (sscanf(line, "pidir=%s", pidir) == 0)
        sscanf(line, "PIDIR=%s", pidir);
    }
    cfgread = 1;  
  }
  
  if (fno != fno_pi) {
    if (fp_pi != NULL)
      fclose(fp_pi);
    // replace any backslashes in pidir by forward slashes
    while (strchr(pidir, '\\') != NULL)
      *strchr(pidir, '\\') = '/';
    // strop-off a final slash
    if (pidir[strlen(pidir)-1] == '/')
      pidir[strlen(pidir)-1] = '\0';
    sprintf(fn_pi, pi_filename_fmt, pidir, fno);
    fp_pi = fopen(fn_pi, "rb");
    fno_pi = -1;
    if (fp_pi) {
      fno_pi = fno;
      if (fno == fno_first && fno_last < 0) { // first touch of first file
			  char buf[100];
        int n = fread(buf, 1, sizeof(buf)-1, fp_pi);
        buf[n] = '\0';
            
        if (n != strspn(buf, "0123456789"))
          progexit(1, "First pi file %s contains not only decimal digits.\n"
                      	"No sense to continue.\n", fn_pi);
        if (strncmp(buf, "314159", 6) == 0)
          bStartsWith3 = 1;
        else
          if (strncmp(buf, "14159", 5) == 0)
            bStartsWith3 = 0;
          else
            progexit(1, "First pi file %s does not begin with [3]14159\n"
                      	"No sense to continue.\n", fn_pi);
      }
      if (fno > fno_last) {
        fseek(fp_pi, 0, SEEK_END);
        fsize[fno] += ftell(fp_pi);
        fseek(fp_pi, 0, SEEK_SET);
        fno_last = fno;
      }
    }
  }
  return fp_pi;
}

/* fread_pi reads the next at most n-1 decimal digits of pi
	(as ascii characters) into the array s;
	the array is terminated by '\0 '.
	fread_pi returns the number of digits read,
	or 0 if end-of-file or error occurs.
*/

size_t fread_pi(char *s, size_t n)
{
	size_t 			m = 0;

   --n;
   if (lTrue == -1) {
      *s = '3';
	   lTrue = 0;
      m = 1;
   }
   do {
		m += fread(s+m, 1, n-m, fp_pi);
   	if (m < n)  // file end of current pi file reached
      	fp_pi = fopen_pi(fno_pi+1);
   } while (m < n && fp_pi != NULL);
   s[m] = '\0';
	return m;
}

/* fseek_pi sets the file position for the set of pi files;
	a subsequent fread_pi will access the pi digits at the new position.
	The position is set to <offset> digit chars from the
   beginning of the first pi file of the set.
	fseek_pi returns the new file position or -1 at error.
*/
long fseek_pi(long offset)
{
   long offset1 = !bStartsWith3;
   int  fno;

   for (fno=fno_first; fno <= fno_last; ++fno)
   	if ((offset1 += fsize[fno]) > offset)
         break;
   if (fno > fno_last)
   	return -1; // offset > size of pi file set
   fp_pi = fopen_pi(fno);
   offset1 -= fsize[fno];
   lTrue = offset - offset1;
   fseek(fp_pi, lTrue < 0 ? 0 : lTrue, SEEK_SET);
   return offset;
}


