
/************************************************************
*
* *** shortest(?) possible ANSI-C-Pi program
* Expanded version
*
* Thanks to Dik T. Winter and Achim Flammenkamp
*
************************************************************/

#include "picheck.h"            /* debugging               */

#define NDIGITS 32600           /* max. digits to compute  */
#define LEN   (NDIGITS/4+1)*14  /* nec. array length       */

long a[LEN];                    /* array of 4 digit-decimals*/
long b;                         /* nominator prev. base    */
long c = LEN;                   /* index                   */
long d;                         /* accumulator and carry   */
long e = 0;                     /* save prev. 4 digits     */
long f = 10000;                 /* new base, 4 dec. digits */
long g;                         /* denom prev. base        */
long h = 0;                     /* init switch             */

int main(int argc, char *argv[])
{
	long ndigits, nbeg = 4, nend = 1000, nstep=4;

   if (argc > 1) nbeg = nend = atol(argv[1]);
   if (argc > 2) nend = atol(argv[2]);
   if (argc > 3) nstep= atol(argv[3]);
	nend =  max(4, (min(NDIGITS, nend)/4)*4);
	nbeg =  max(4, (min(nbeg, nend)/4)*4);
   nstep = max(4, (nstep/4)*4);

	for (ndigits=nbeg; ndigits <= nend; ndigits+=nstep) {
		c = (ndigits/4+1)*14;
		e = h = 0;

		for ( ;(b=c-=14) > 0; )   /* outer loop:4 digits/loop*/
		{
			for (; --b > 0; )      /* inner loop: radix conv  */
			{
				d *= b;             /* acc *= nom. prev base   */
				if (h == 0)
					d += 2e7;   /* first outer loop        */
				else
					d += a[b] * 1e4;   /* non-first outer loop    */
				g=b+b-1;            /* denom prev. base        */
				a[b] = d % g;
				d /= g;             /* save carry              */
			}
			h = printf("%04ld", e + d/f);  /* print prev 4 digits*/
			d = e = d % f;         /* save current 4 digits   */
		}
	}
	return 0;
}
/*
long a[LEN],b,c=LEN,d,e,f=1e4,g,h;
main(){for(;b=c-=14;h=printf("%04ld",e+d/f))
for(e=d%=f;g=--b*2;d/=g)d=d*b+f*(h?a[b]:f/5),a[b]=d%--g;}
*/



