
#include "mod.h"
#include "modm.h"
#include "mfft.h"


#define  SLOW_MOD_CONVOLUTION_VERSION  0  // 1 or 2

#if  ( SLOW_MOD_CONVOLUTION_VERSION==1 )

void
slow_mod_convolution(mod *f, mod *g, ulong n)
//
// _cyclic_ convolution
// (use zero padded data for usual co.)
//
{
    mod *r = new mod[n];

    for(ulong tau=0; tau<n; ++tau)
    {
	mod t = mod::zero;
	for(ulong k=0; k<n; ++k)
	{
	    ulong k2;

	    if ( tau>=k )  k2 = tau-k;
	    else           k2 = n+tau-k;

	    t += (f[k2]*g[k]);
	}

        r[tau] = t;
    }

    copy(r,g,n);

    delete [] r;
}
//============== end SLOW_MOD_CONVOLUTION =================

#else // ( SLOW_MOD_CONVOLUTION_VERSION==1 )

void
slow_mod_convolution(mod *f, mod *g, ulong nu)
//
// _cyclic_ convolution
// result in g
//
{
    long n = (long)nu;

    mod *r = new mod[n];

    for(long tau=0; tau<n; ++tau)
    {
	mod s = mod::zero;
	for(long k=0; k<n; ++k)
	{
             long k2 = tau-k;

             if ( k2<0 )  k2 += n;

	     s += (f[k]*g[k2]);
	}

        r[tau] = s;
    }

    copy(r,g,n);

    delete [] r;
}
// ============== end SLOW_MOD_CONVOLUTION ================

#endif // ( SLOW_MOD_CONVOLUTION_VERSION==1 )


void
slow_mod_convolution(double *f, double *g, ulong n)
{
    double_to_mod_by_force(f,n);
    double_to_mod_by_force(g,n);
    slow_mod_convolution((double*)f,(double*)g,n);
}
// ============== end SLOW_MOD_CONVOLUTION ================

