
#include <iostream.h>

#include "mod.h"
#include "modm.h"
#include "factor.h"


umod_t
phi(umod_t n)
{
    factorization ff(n);
    return  phi(ff);
}
//================= end PHI ================


umod_t
phi(const factorization &ff)
{
//    cout << "\n phi(): " << endl;

    umod_t p = 1;
    for(int i=0; i<ff.npr; ++i)
    {
        umod_t v;
        long e = ff.exponent[i];
        umod_t f = ff.prime[i];

        if ( e==1 )  v=f-1;
        else         v=ipow(f,e)-ipow(f,e-1);

        p *= v;

//        cout << i << ":  f=" << f << "  e=" << e 
//             << "  v=" << v << "  p=" << p << endl;
    }

    return p;
}
//================= end PHI ================
