#if !defined __SINCOS_H
#define      __SINCOS_H


#if defined __GNUC__  // if GNUC
#if defined __i386__  // if intel cpu >=i386

#define FPU_SINCOS    // use the sincos instruction

#endif  /* defined __i386__ */
#endif  /* defined __GNUC__ */



// whether to use the assembler template version:
// (avoids call overhead)
#define TEMPL_SC


#if defined FPU_SINCOS

#if defined TEMPL_SC  // use asm template

#define sincos(c,s,a) \
asm("fld %2; fsincos; fstpl %0; fstpl %1" \
    : "=m" (*((c))), "=m" (*((s))) \
    : "f" ((a)))

#else  // use asm (see sincos.cc)

extern "C" void
sincos(double *c, double *s, double a);

#endif  /* defined TEMPL_SC */

#else

#include <math.h>

inline void
sincos(double *c, double *s, double a)
{
    *s = sin(a);
    *c = cos(a);
}

#endif  /* defined FPU_SINCOS */


#endif  // !defined __SINCOS_H
