/* Copyright (C) 1997 DJ Delorie, see COPYING.DJ for details */
/*
** I am not including a copy of the D.J. license because if you
** need this routine, then you have DJGPP, and already have
** a copy of it.  If you want to read it, get any DJGPP program.
*/
/*
** This is a very slightly modified version of 'malloc6.c' that
** D.J. Delorie has on his web page, to replace the malloc that
** he includes in DJGPP.  Considering how pathetic and annoying
** that one was, I certainly hope he lost a lot of sleep from
** a guilty conscience!
**
** It was designed for DJGPP, and may or may not be portable to
** other systems.  Although I doubt there are any other systems
** that would need to replace it.
**
** The alignment stuff at the bottom is mine and does not fall under
** DJ Delorie's Copyright nor the GNU Copyright.
*/

#include <stdlib.h>
#include <stdio.h>

#ifdef USE_SPECIAL_DJGPP_MALLOC

#include <assert.h>
#include <unistd.h>
#include <stdlib.h>

/*char *MallocVer="Malloc6.c";*/

typedef struct BLOCK {
  int size;
  struct BLOCK *next;
  int bucket;
} BLOCK;

#define BEFORE(bp)	((BLOCK *)((char *)bp - *(int *)((char *)bp - 4) - 8))
#define BEFSZ(bp)	(*(int *)((char *)bp - 4))
#define ENDSZ(bp)	(*(int *)((char *)bp + bp->size + 4))
#define AFTER(bp)	((BLOCK *)((char *)bp + bp->size + 8))
#define DATA(bp)	((char *)&(bp->next))

#define ALIGN		64

BLOCK *slop = 0;
BLOCK *freelist[30];

#define MIN_SAVE_EXTRA	64

#define CHECK(p)

static int
size2bucket(unsigned size)
{
  int rv=0;
  size>>=2;
  while (size)
  {
    rv++;
    size>>=1;
  }
  return rv;
}

static int
b2bucket(BLOCK *b)
{
  if (b->bucket == -1)
    b->bucket = size2bucket(b->size);
  return b->bucket;
}

static BLOCK *
split_block(BLOCK *b, int size)
{
  BLOCK *rv = (BLOCK *)((char *)b + size+8);
  rv->size = b->size - size - 8;
  rv->bucket = -1;
  b->size = size;
  ENDSZ(b) = b->size;
  ENDSZ(rv) = rv->size;
  CHECK(b);
  CHECK(rv);
  return rv;
}

#define RET(rv) CHECK(rv); ENDSZ(rv) |= 1; rv->size |= 1; return DATA(rv)

void *
malloc(size_t size)
{
  int b, chunk_size;
  BLOCK *rv, **prev;
  static BLOCK *expected_sbrk = 0;

  static int initted=0;
  if (!initted)
  {
    initted = (int)sbrk(0);
  }

  if (size<ALIGN) size = ALIGN;
  size = (size+(ALIGN-1))&~(ALIGN-1);

  if (slop && slop->size >= size)
  {
    rv = slop;
    if (slop->size >= size+MIN_SAVE_EXTRA)
    {
      slop = split_block(slop, size);
    }
    else
      slop = 0;
    RET(rv);
  }

  b = size2bucket(size);
  prev = &(freelist[b]);
  for (rv=freelist[b]; rv; prev=&(rv->next), rv=rv->next)
  {
    if (rv->size >= size && rv->size < size+size/4)
    {
      *prev = rv->next;
      RET(rv);
    }
  }

  while (b < 30)
  {
    prev = &(freelist[b]);
    for (rv=freelist[b]; rv; prev=&(rv->next), rv=rv->next)
      if (rv->size >= size)
      {
	*prev = rv->next;
	if (rv->size >= size+MIN_SAVE_EXTRA)
	{
	  if (slop)
	  {
	    b = b2bucket(slop);
	    slop->next = freelist[b];
	    freelist[b] = slop;
	  }
	  slop = split_block(rv, size);
	}
	RET(rv);
      }
    b++;
  }

  chunk_size = size+16; /* two ends plus two placeholders */
  rv = (BLOCK *)sbrk(chunk_size);
  if (rv == 0)
    return 0;
  if (rv == expected_sbrk)
  {
    expected_sbrk = (BLOCK *)((char *)rv + chunk_size);
    /* absorb old end-block-marker */
    rv = (BLOCK *)((char *)rv - 4);
  }
  else
  {
    expected_sbrk = (BLOCK *)((char *)rv + chunk_size);
    /* build start-block-marker */
    rv->size = 1;
    rv = (BLOCK *)((char *)rv + 4);
    chunk_size -= 8;
  }
  rv->size = chunk_size - 8;
  ENDSZ(rv) = rv->size;
  AFTER(rv)->size = 1;
  CHECK(rv);

  RET(rv);
}

static BLOCK *
merge(BLOCK *a, BLOCK *b, BLOCK *c)
{
  int bu;
  BLOCK *bp, **bpp;

  CHECK(a);
  CHECK(b);
  CHECK(c);
  if (c == slop)
  {
    slop = 0;
  }
  bu = b2bucket(c);
  bpp = freelist+bu;
  for (bp=freelist[bu]; bp; bpp=&(bp->next), bp=bp->next)
  {
    if (bp == c)
    {
      *bpp = bp->next;
      break;
    }
  }
  CHECK(c);

  a->size += b->size + 8;
  a->bucket = -1;
  ENDSZ(a) = a->size;

  CHECK(a);
  return a;
}

void
free(void *p)
{
  char *ptr=(char*)p;
  int b;
  BLOCK *block;

  if (ptr==NULL) return;

  block = (BLOCK *)(ptr-4);

  block->size &= ~1;
  ENDSZ(block) &= ~1;
  block->bucket = -1;

  CHECK(block);
  if (! (AFTER(block)->size & 1))
  {
    CHECK(AFTER(block));
  }
  if (! (BEFSZ(block) & 1))
  {
    CHECK(BEFORE(block));
    block = merge(BEFORE(block), block, BEFORE(block));
  }
  CHECK(block);
  if (! (AFTER(block)->size & 1))
  {
    CHECK(AFTER(block));
    block = merge(block, AFTER(block), AFTER(block));
  }
  CHECK(block);

  b = b2bucket(block);
  block->next = freelist[b];
  freelist[b] = block;
  CHECK(block);
}

void *
realloc(void *p, size_t size)
{
  char *ptr=(char*)p;
  BLOCK *b;
  char *newptr;
  int copysize;

  if (ptr==NULL) return malloc(size);

  b = (BLOCK *)(ptr-4);
  copysize = b->size;

  if (size <= b->size)
  {
#if 0
    if (b->size < 2*MIN_SAVE_EXTRA
	|| (size >= b->size-512 && size >= b->size/2))
#endif
      return ptr;
    copysize = size;
  }

  newptr = (char *)malloc(size);
  memcpy(newptr, ptr, copysize);
  free(ptr);
  return newptr;
}
#endif

#ifdef ALIGN_MALLOC
void *
AlignedMalloc(size_t len)
{void *ptr;
ptr=malloc(len+300);
if (ptr != NULL)
  {unsigned long int Addr;
   void *NewPtr=ptr;
   void **vpp;
   unsigned char *cp;

   vpp=(void**)NewPtr;vpp++;NewPtr=(void*)vpp; /* allow space to save orig.*/
   Addr=(unsigned long int)NewPtr;
   while ((Addr % 256)!=0)
     {
      cp=(unsigned char*)NewPtr;
      cp++;
      NewPtr=(void*)cp;
      Addr=(unsigned long int)NewPtr;
     }
/* It's now aligned.  Save it. */
/*fprintf(stderr,"alloc: Orig pointer=%p Aligned pointer=%p\n",ptr,NewPtr);*/
   vpp=(void**)NewPtr;
   vpp--;
   *vpp=ptr;
   ptr=NewPtr;
   }
return ptr;
}

void
AlignedFree(void *NewPtr)
{void **vpp;void *ptr;
if (NewPtr==NULL) return;
vpp=(void**)NewPtr;
vpp--;
ptr=*vpp;
/*fprintf(stderr,"free : Orig pointer=%p Aligned pointer=%p\n",ptr,NewPtr);*/
free(ptr);
}

#else
void *
AlignedMalloc(size_t len)
{void *ptr;
ptr=malloc(len);
#if 0
if (ptr != NULL)
  {unsigned long int x=(unsigned long int)ptr;
   if ((x % sizeof(double))!=0)
     {
      fprintf(stderr,"Warning: AlignedMalloc has a pointer to %lu bytes that is\n",(ULINT)len);
      fprintf(stderr,"not aligned on a sizeof(double) boundary.  %p\n",ptr);
      fprintf(stderr,"This is not a fatal problem. Just a performance problem.\n");
     }
   }
#endif
return ptr;
}

void
AlignedFree(void *ptr)
{
if (ptr!=NULL) free(ptr);
}
#endif


