
double rnd01()
//
// random number in [0,1[
//
{
    return -(double)random()*(1.0/(1<<31));
}
//================= end RND01 =================


double scalar_product(double *f, double *g, ulong n)
{
    double p=0;
    for(ulong i=0; i<n; ++i)  p+=f[i]*g[i];

    return(p);
}
//================= end SCALAR_PRODUCT =================


void normalize(double *f, ulong n, double v=1.0)
//
// normalize vector
//
{
    v *= sqrt(scalar_product(f,f,n));

    for(ulong i=0; i<n; ++i)  f[i] *= v;
}
//================= end NORMALIZE =================



double pythag(double a, double b)
//
// return sqrt(a*a+b*b)
//
{
    a=fabs(a);
    b=fabs(b);

    if (a>b)  return  a*sqrt(1.0+sqr(b/a));
    else      return  b==0.0?0.0:b*sqrt(1.0+sqr(a/b));
}
//================= end PYTHAG ===================



double 
mean(double *f, ulong n)
{
    double mean=0;

    for(ulong i=0; i<n; ++i)	mean+=f[i];

    mean/=(double)n;

    return(mean);
}
//================= end MEAN ======================



double 
subtract_mean(double *f, ulong n, double *dest=NULL)
{
    if(dest==NULL)  dest=f;	 // default dest = source.real

    double m=mean(f,n);

    for(ulong i=0; i<n; ++i)
    {
	dest[i]=f[i]-m;
    }

    return(m);
}
//================= end MEAN ======================



double 
max(double *f, ulong n)
{
    double max=f[0];

    for(ulong i=1; i<n; ++i)
    {
	if(max<f[i])  max=f[i];
    }

    return(max);
}
//================= end MAX =====================



ulong 
minmax(double *f, ulong n, double *absmin, double *absmax, ulong useminmax=0)
//
// find min and max of f[]
// default: find min & max (don't care of values in absmin,absmax)
// else: update absmin,absmax
//
{
    ulong i;
    double max;
    double min;


    if(useminmax==0)		   // start with new min max ?
    {
	max=f[0];
	min=f[0];
    }
    else
    {
	max=*absmin;
	min=*absmax;
    }


    for(i=0; i<n; ++i)
    {
	if(max<f[i])  max=f[i];

	if(min>f[i])  min=f[i];
    }


    *absmin=min;
    *absmax=max;

    return(0);
}
//================= end MINMAX ==================



double 
sigma(double *f, ulong n)
//
// find standard deviation sigma of f[]
//
{
    ulong i;
    double t;
    double mean;
    double sigma;


    // --- compute mean:
    mean=0;
    for(i=0; i<n; ++i)	mean+=f[i];
    mean/=(double)n;

    // --- compute sigma:
    sigma=0;
    for(i=0; i<n; ++i)
    {
	t=f[i]-mean;
	sigma+=t*t;
    }

    sigma/=n;
    sigma=sqrt(sigma);

    return(sigma);
}
// =============== end SIGMA ==============



void 
welch_win(double *f, ulong n)
//
//	multiply f[] with a welch window
//	(used to reduce clip effects in FFT spectral estimation)
//
{
    double pin;
    double sq2=M_SQRT2;
    double ct;

    pin=M_PI/n;

    for(ct=0; ct<n; ct++)  f[(ulong)ct] *= (sq2*sin(ct*pin));

}
// ================== end WELCH_WIN ===============



double white_noise()
//
// returns one sample from white noise (with sigma=1)
//
{
    double pi2=2*M_PI;
    double r1, r2, z1;

    r1=(-(double)random() * (1.0/(1<<31))) ;  // r1=random in [0,1[
    r2=(-(double)random() * (1.0/(1<<31))) ;  // r2=random in [0,1[

    r1=sqrt(-2*log(r1));
    r2=pi2*r2;

    z1=r1*cos(r2);
    //    z2=r1*sin(r2);        // independent second

    return(z1);
}
//========== end WHITE_NOISE =========




ulong sample_down(const double *f, ulong n, double v, double *g, ulong maxn)
//
// uses linear interpolation (if noninteger v)
//
// returns number of values produced
//
{
    ulong    gi, fi;

    assert(v>=1.0);

    mct=ulong(n/v);                // so many values will be produced

    if(mct>maxn)  mct=maxn;


    if(v==round(v))                // ----- integer value
    {
        const ulong vi=ulong(round(v));

        for(fi=0,gi=0; gi<mct; gi++,fi+=vi)
        {
            f[gi]=f[fi];
        }
    }
    else                           // ----- non integer value
    {
        double dfi, frac;

        for(dfi=0,gi=0; gi<mct; gi++,dfi+=v)
        {
            fi=ulong(dfi);
            frac=dfi-double(fi);

            // linear interpolation:
            f[gi]=f[fi]+(f[fi+1]-f[fi])*frac;
        }
    }

    return gi;
}
//=============== end SAMPLE_DOWN =====================


ulong sample_up(const double *f, ulong n, double v, double *g, ulong maxn)
//
// uses linear interpolation (if noninteger v)
//
// returns number of values produced
//
{
    ulong    gi, fi;

    assert(v<=1.0);

    mct=ulong(n/v);                // so many values will be produced

    if(mct>maxn)  mct=maxn;

    if(v==round(v))                // ----- integer value
    {
        const ulong vi=ulong(round(v));

        for(fi=0,gi=0; gi<mct; gi++,fi+=vi)
        {
            g[gi]=f[fi];
        }
    }
    else                           // ----- non integer value
    {
        double dfi, frac;

        for(dfi=0,gi=0; gi<mct; gi++,dfi+=v)
        {
            fi=ulong(dfi);
            frac=dfi-double(fi);

            // linear interpolation:
            g[gi]=f[fi]+(f[fi+1]-f[fi])*frac;
        }
    }

    return gi;
}
//=============== end SAMPLE_UP ==================


