
#include <assert.h>
#include <stdlib.h>
#include <iostream.h>
#include <Complex.h>

#include "fxtaux.h"


#define CHOP(x)      (fabs(x)<1e-12 ? 0:x)


void
c_copy(Complex *src, Complex *dst, long n)
{
    while( n-- )  dst[n]=src[n];
}
//================ end C_COPY ===============


void
dc_copy(double *srcre, double *srcim, Complex *dst, long n)
{
    while ( n-- )  dst[n]=Complex(srcre[n],srcim[n]);
}
//================ end DC_COPY ===============


void
cd_copy(Complex *src, double *dstre, double *dstim, long n)
{
    while ( n-- )
    {
        dstre[n]=src[n].real();
        dstim[n]=src[n].imag();
    }
}
//================ end CD_COPY ===============


void
c_null(Complex *f, long n)
{
    while ( n-- )  f[n]=0.0;
}
//================ end C_NULL ===============


void
c_fill(Complex *f, long n, Complex v)
{
    while ( n-- )  f[n]=v;
}
//================ end C_FILL ===============


void
c_rand(Complex *a, long n)
{
//    srand(time(0));

    for (long k=0; k<n; ++k)
    {
        a[k]=Complex((double)rand()*(1.0/RAND_MAX),
                     (double)rand()*(1.0/RAND_MAX));
    }
}
// ================== end C_RAND ===================


void
c_print(char *what, Complex *c, long n)
{
    cout<<what;

    for(long k=0; k<n; ++k)
    {
        cout << CHOP(c[k].real())
	     << CHOP(c[k].imag())
	     << endl;
    }

    cout<<flush;
}
//=============== end C_PRINT ===========


void
c_scramble(Complex *f, long n)
//
//  put complex data in revbin order
//
{
    for (long k1=1,k2=0;k1<n;k1++)
    {
        for (long k=n>>1; (!((k2^=k)&k)); k>>=1);

        if (k1>k2)  { Complex t=f[k1]; f[k1]=f[k2]; f[k2]=t; }
    }
}
//============== end CSCRAMBLE ==================


void
complex_to_real_imag(Complex *c, long n)
//
// this routine transforms
// complex data into two seperate fields
// with real and imag data (inplace)
// (the data must lie in contiguous memory)
//
{
    double *fr, *fi;

    fr=(double*)c;
    fi=fr+n;

    scramble((double *)c,n*2);

// at this point the real and imag data
// lies (in revbin order) in the low and hi half

    scramble(fr,n);
    scramble(fi,n);
}
//============= end COMPLEX_TO_REAL_IMAG  ============


void
real_imag_to_complex(double *fr, double *fi, long n)
//
// this routine transforms
// two seperate fields with real and imag
// data into complex data (inplace)
//
{
    Complex *c;

    assert(fi==fr+n); // must lie in contiguous mem

    c=(Complex *)fr;

    scramble(fr,n);
    scramble(fi,n);

// at this point the real and imag data
// lies (in revbin order) in the low and hi half

    scramble((double *)c,2*n);
}
//============= end REAL_IMAG_TO_COMPLEX ============

