
#include "mtypes.h"
#include "factor.h"
#include "jjassert.h"


int
reciprocity(umod_t a, umod_t b)
//
// (a/b) = (-1)^((a1-1)*(b1-1)/4 + (as-1)*(bs-1)/4) *(b/a)
// where a==a1*2^ae, b=b1*2^be
// and as=sign(a), bs=sign(b)
// cf. cohen p.43
//
// UNTESTED
{
    if ( (0==a) || (0==b) )  return 0;

//    int ae=0, be=0;

    while ( 0==(a&1) )
    {
//        ae++;
        a >>= 1;
    }

    while ( 0==(b&1) )
    {
//        be++;
        b >>= 1;
    }

    int k = 1;
    if ( a&b&2 )  k = -k;

    
//    if ( as&bs&2 )  k = -k;  // as=sign(a), bs=sign(b)

    return k;
}
//================= end RECIPROCITY ================


int
kronecker(umod_t a, umod_t b)
//
// cf. cohen p.29
// return kronecker symbol (a/b)
// which, if b is an odd prime, == legendre symbol (a/b)
// 
// UNTESTED
{
    static const int  tab2[] = {0,1,0,-1,0,-1,0,1};
    // (-1)^((a^2-1)/8) == tab2[a&7]

    if ( 0==b )
    {
        if ( 1!=a )  return 0;  // 1==abs(a)
        else         return 1;
    }

    // a and b are both even ?
    if ( (0==(a&1)) && (0==(b&1)) )  return 0;

    int v = 0;
    while ( 0==(b&1) )
    {
        v++;
        b >>= 1;
    }

    int k;
    if ( 0==(v&1) )  k = 1;
    else             k = tab2[a&7];

    /*
    if ( b<0 )
    {
        b = -b;
        if ( a<0 )  k = -k;
    }
    */

step3:
    jjassert ( b&1 );  // b is odd

    if ( 0==a )
    {
        if ( b>1 )  return 0;
        else        return k;
    }

    v = 0;
    while ( 0==(a&1) )
    {
        v++;
        a >>= 1;
    }

    if ( 1==(v&1) )  k *= tab2[b&7];

    // k = k*(-1)^((a-1)*(b-1)/4)
    if ( a&b&2 )  k = -k; 

    umod_t r = a; // abs(a)
    a = b%r;
    b = r;
    goto step3;
}
//================= end KRONECKER ================

