#if !defined __MODARITH_H
#define      __MODARITH_H

//
// (inline) ARITHMETIC modulo mod::modulus
// (cf. arithmodm.cc)
//

#include <assert.h>

#include "mtypes.h"


// these are defined in modinit.cc:
extern umod_t        mod_modulus;    // ==(mod::modulus)
extern long double   mod_m1dd;       // ==(mod::m1dd)

#define MODULUS    (mod_modulus)
#define M1DD       (mod_m1dd)

#define   MOD_PARANOIA   0   // 0 or 1 (enables many asserts)


inline umod_t
u_set_mod_mod(umod_t x)
{
    if ( x>=(umod_t)MODULUS )  x %= (umod_t)MODULUS;

#if  ( MOD_PARANOIA )
#if  ( ! USE_LEQ_63BIT_MODULUS )
    assert( (smod_t)x>=0 );
#endif
    assert( (umod_t)x<MODULUS );
#endif
    
    return x;
}
// ============ end U_SET_MOD_MOD ===========



inline umod_t
incr_mod_mod(umod_t a)
{
    a++;
    if ( a==MODULUS )  a = 0;
    return a;
}
// ============ end INCR_MOD_MOD ===========


inline umod_t
decr_mod_mod(umod_t a)
{
    if ( a==0 )  a = MODULUS-1;
    else         a--;
    return a;
}
// ============ end DECR_MOD_MOD ===========



inline umod_t
add_mod_mod(const umod_t &a, const umod_t &b)
{
#if  ( MOD_PARANOIA )
    assert( a<MODULUS );
    assert( b<MODULUS );
#endif

    umod_t s = a+b;
#if  ( ! USE_LEQ_63BIT_MODULUS )
#error " add_mod_mod() might fail. "
    // must subtract m if:
    // 1.  (sum<summand1) AND (sum<summand2), i.e. result 'wrapped around'
    if ( (s<a)&&(s<b) )   return s-MODULUS;
#endif

    // 2.  sum >= m
    if ( s>=MODULUS )   return  s-MODULUS;

    return s;
}
// ============ end ADD_MOD_MOD ===========


inline umod_t
sub_mod_mod(const umod_t &a, const umod_t &b)
{
#if  ( MOD_PARANOIA )
    assert( a<MODULUS );
    assert( b<MODULUS );
#endif

    if ( a>=b )  return  a-b;
    else         return  MODULUS-b+a;
}
// ============ end SUB_MOD_MOD ===========



// MULTIPLIES:

#if  ( USE_64BIT_MOD_T )

#if  ( USE_LEQ_63BIT_MODULUS )
#define  mul_mod_mod(a,b)  inline_mul_mod_mod((a),(b))
#else
#error  "no 64bit multiply yet"
#endif // ( USE_LEQ_63BIT_MODULUS )


inline
umod_t
inline_mul_mod_mod(const umod_t &a, const umod_t &b)
{
    umod_t qt = (umod_t)((ldouble)a*(ldouble)b*(M1DD)+(ldouble)1/2 );
    umod_t ab = (umod_t)a * (umod_t)b;
    umod_t mq = (umod_t)MODULUS * (umod_t)qt;
    smod_t rem = (smod_t)(ab-mq);
    if ( rem<0 )  { rem += MODULUS; qt--; }
    return  (umod_t)rem;
}


// modmult.cc:
umod_t  mul_mod_mod_63bit(const umod_t &a, const umod_t &b);
umod_t  mul_mod_mod_64bit(umod_t a, umod_t b);



#else // USE_64BIT_MOD_T


inline umod_t
mul_mod_mod(const mod_t a, const mod_t b)
{
    uint64 r= (uint64)a*(uint64)b;
    r = r%(uint64)MODULUS;
    return  (umod_t)r;
}


#endif // USE_64BIT_MOD_T



#endif  // !defined __MODARITH_H
