
#include <iostream.h>

#include "mod.h"
#include "modm.h"
#include "modarith.h"
#include "jjassert.h"



umod_t
order(mod x)
{
    return  order_mod( x.x ,mod::modulus, mod::pfact);
}
//================= end ORDER ================


umod_t
find_maxorder()
{
    return  find_maxorder_mod(mod::mfact);
}
//================= end FIND_MAXORDER ================


umod_t
find_maxorder_element()
{
    return  find_maxorder_element_mod(mod::mfact,mod::maxorder,mod::pfact);
}
//================= end FIND_MAXORDER_ELEMENT ================


umod_t
find_primitive_root()
{
    return  find_primitive_root_mod(mod::modulus, mod::pfact);
}
//================= end FIND_PRIMITIVE_ROOT ================


int
is_primitive_root(mod r)
{
    return  is_primitive_root_mod(r.x, mod::modulus, mod::pfact);
}
//================= end IS_PRIMITIVE_ROOT ================



mod
div(const mod& m1, const mod& m2)
{
    mod t = inv(m2);
    mul(m1,t,t);
    return t;
}
// ============= end DIV ===========


#define  INV_USE_EGCD  0  // vs. use powering
// " egcd only works for modulus <=63bit ! "

mod
inv(const mod& z)
{
#if  ( INV_USE_EGCD )

#if  ( ! USE_LEQ_63BIT_MODULUS )
#error " inv(): egcd_core() will fail. "
#endif

    smod_t m = (mod::modulus);
    smod_t x = z.x;
    smod_t d;
    smod_t u,v;

    d = egcd(m,x,u,v);      // d==m*u+x*v
//    jjassert(  d==m*u+x*v );  // whether egcd worked
    jjassert(  d==1 );        // inversion possible <==> gcd(x,m)==1

    if ( v<0 )  v = m+v;

    mod i = mod(v);

#else //  ( INV_USE_EGCD )

    mod i = pow(z,mod::phi-1);  // z^-1 = z^(phi(m)-1), cf. cohen p.19

#endif // ( INV_USE_EGCD )

    if ( z*i!=(mod::one) )
    {
	jjassert( 0*(int)"inv() failed" );
    }

    return i;
}
// ============= end INV ===========


mod
invpow(const mod& a, umod_t ex)
{
    if ( ex==0 )  
    {
        return mod::one;
    }
    else
    {
        mod z = inv(a);
        z = pow(z,ex);
        return z;
    }
}
// ============= end INVPOW ===========



mod
pow(const mod& a, umod_t ex)
{
//    cout << "\n " << __FUNCTION__ 
//         << "(" << a << ", " << ex << ")\n";

    if ( ex==0 )  
    {
        return mod::one;
    }
    else
    {
        mod z = a;
        mod y = (mod::one);

        while( 1 )
        {
            if ( ex&1 )  y *= z;
            
            ex /= 2;

            if ( ex==0 )  break;

            z *= z;
        }

        return y;
    }
}
// ============= end POW ===========



mod
root(umod_t r)
//
// find root of unity of order r
//
{
    umod_t mx = mod::maxorder;

    if ( r==mx )
    {
        return mod::primroot;
    }
    else
    {
        umod_t mxr = mx/r;

        if ( (mxr*r)!=mx )  // r must be a divider of maxorder
        {
            cerr << " request for root of impossible order " << r << endl;
            jjassert( 0 );
        }

        mod  h = pow(mod::primroot,mxr);
//        jjassert( r==order(h) );
        return h;
    }
}
// ============= end ROOT ===========


mod
invroot(umod_t r)
//
// find inverse root of unity of order r
//
{
    umod_t mx = mod::maxorder;

    if ( r==mx )
    {
        return mod::inverse_primroot;
    }
    else
    {
        umod_t mxr = mx/r;

        if ( (mxr*r)!=mx )  // r must be a divider of maxorder
        {
            cerr << " request for invroot of impossible order " << r << endl;
            jjassert( 0 );
        }

        mod  h = pow(mod::inverse_primroot,mxr);
//        jjassert( r==order(h) );
        return h;
    }
}
// ============= end INVROOT ===========
