
#include "mod.h"
#include "modm.h"
#include "jjassert.h"


#define  ORDER_PRINT_LIKE_MAD  0  // 0 or 1

umod_t
order_mod(umod_t x, umod_t m, const factorization &phifact)
//
// finds order of x
// cf. cohen, p.25
{
    // pari says:  ***   not an element of (Z/nZ)* in order
    if ( 1!=gcd(m,x) )  return 0;

    umod_t h = phifact.product();
//    umod_t h = mod::phi;
//    const factorization &phifact = mod::pfact; // fact of phi

#if  ( ORDER_PRINT_LIKE_MAD )
    phifact.print("\n order(): ... ");
    cout << " x=" << x << endl;
#endif

    umod_t e = h;
#if  ( ORDER_PRINT_LIKE_MAD )
    cout << "\n e=phi=" << e << endl; 
#endif

    for (int i = 0; i<phifact.npr ; ++i)
    {
        umod_t p  = phifact.prime[i];
        long v    = phifact.exponent[i];
        umod_t pp = phifact.factor(i);

#if  ( ORDER_PRINT_LIKE_MAD )
        cout << "\n p_i=" << p << "  v_i=" << v << endl;
        cout << "    p_i^{v_i}=P=" << pp << endl; 
        cout << "    e=" << e << endl; 
#endif
        jjassert( (e/pp)*pp==e );

        e /= pp;
#if  ( ORDER_PRINT_LIKE_MAD )
        cout << "   x=" << x << "  e=" << e << endl; 
#endif
        umod_t g1 = pow_mod(x,e,m);

#if  ( ORDER_PRINT_LIKE_MAD )
        cout << " local order, x^e = g1=" << g1 << ": \n";
        cout << "    e=" << e << endl; 
#endif

        while ( g1!=1 )
        {
            g1 = pow_mod(g1,p,m);
            e *= p;
//            assert ( g1!=(uint)0 );
//            jjassert( e!=0 );
//            jjassert( e<=h );  // e==h only possible if g1==1

            v--;
#if  ( ORDER_PRINT_LIKE_MAD )
            cout << "  v=" << v 
                 << ": g1=" << g1 
                 << "  p=" << p 
                 << "  e=" << e << "\n";
#endif
           jjassert( v>=0 );
        }
    }

    return e;
}
//================= end ORDER_MOD ================
