
#include "fxtaux.h"


//  scramble() put data into revbin order
//  scramble0() same for zero padded data


#define VERSION 1  // 1 or 2  (1 is much faster)

/* timing: (in ms/call for length 256k, cpu= intel i486/100)
VERSION==1:
   379.99   scramble(double *, ulong)
   180.00   scramble0(double *, ulong)
	   
VERSION==2:
  1739.96   scramble(double *, ulong)
   889.98   scramble0(double *, ulong)
*/


#if VERSION==1

void 
scramble(double *fr, ulong n)
{
    for (ulong m=1,j=0; m<n-1; m++)
    {
	{for(ulong k=n>>1; (!((j^=k)&k)); k>>=1);}

	if (j>m)  SWAP(fr[m],fr[j]);
   }
}
//============== end SCRAMBLE =================


void 
scramble0(double *fr, ulong n)
{
    for (ulong m=1,j=0; m<n/2; m++)
    {
	{for(ulong k=n>>1; (!((j^=k)&k)); k>>=1);}

	if (j>m)
        {
	    fr[j]=fr[m];
	    fr[m]=0;
	}

	m++;

	{for(ulong k=n>>1; (!((j^=k)&k)); k>>=1);}

	if (j>m)  SWAP(fr[m],fr[j]);
    }
}
//============== end SCRAMBLE0 =================


void 
scramble(double *fr, double *fi, ulong n)
{
    for (ulong m=1,j=0; m<n-1; m++)
    {
	{for(ulong k=n>>1; (!((j^=k)&k)); k>>=1);}

        if (j>m)
        {
            SWAP(fr[m],fr[j]);
            SWAP(fi[m],fi[j]);
        }
    }
}
//============== end SCRAMBLE =================


void 
scramble0(double *fr, double *fi, ulong n)
{
    for (ulong m=1,j=0; m<n/2; m++)
    {
        {for(ulong k=n>>1; (!((j^=k)&k)); k>>=1);}

	if (j>m)
        {
	    fr[j]=fr[m];
	    fr[m]=0;

	    fi[j]=fi[m];
	    fi[m]=0;
	}

	m++;

	{for(ulong k=n>>1; (!((j^=k)&k)); k>>=1);}

        if (j>m)
        {
            SWAP(fr[m],fr[j]);
            SWAP(fi[m],fi[j]);
        }
    }
}
//============== end SCRAMBLE0 =================

#endif  // VERSION==1 


#if VERSION==2


inline ulong 
revbin(ulong m, ulong ldn)
//
// m=number, ldn=length of m in bits minus one
// used by scramble()
//
{
    ulong j=0;

    while(ldn-->0)
    {
        j<<=1;
        j+=(m&1);
        m>>=1;
    }

    return j;
}
//============== end REVBIN =============

void 
scramble(double *f, ulong n)
{
    ulong ldn=ld(n);

    for(ulong m=1; m<n-1; ++m)
    {
        ulong j=revbin(m,ldn);

        if(j>m) SWAP(f[m],f[j]);
    }
}
//============= end SCRAMBLE ===========


void 
scramble0(double *f, ulong n)
{
    ulong ldn=ld(n);

    for(ulong m=1; m<n/2; ++m)
    {
        ulong j=revbin(m,ldn);

        if(j>m)
	{
            f[j]=f[m];
            f[m]=0.0;
        }

        ++m;
        j=revbin(m,ldn);

        if(j>m) SWAP(f[m],f[j]);
    }
}
//============= end SCRAMBLE0 ===========


void 
scramble(double *fr, double *fi, ulong n)
{
    ulong ldn=ld(n);

    for(ulong m=1; m<n-1; ++m)
    {
        ulong j=revbin(m,ldn);

        if(j>m)
	{
            SWAP(fr[m],fr[j]);
            SWAP(fi[m],fi[j]);
        }
    }

}
//============= end SCRAMBLE ===========


void 
scramble0(double *fr, double *fi, ulong n)
{
    ulong ldn=ld(n);

    for(ulong m=1; m<n/2; ++m)
    {
        ulong j=revbin(m,ldn);

        if(j>m)
	{
            fr[j]=fr[m];
            fr[m]=0.0;

            fi[j]=fi[m];
            fi[m]=0.0;
        }

        ++m;
        j=revbin(m,ldn);

        if(j>m)
	{
            SWAP(fr[m],fr[j]);
            SWAP(fi[m],fi[j]);
        }
    }
}
//============= end SCRAMBLE0 ===========

#endif  // VERSION==2
