

#include "fxtaux.h"
#include "fxt.h"

void 
dit2_walsh_wal(double *f, ulong ldn)
//
// transform wrt. to walsh-kaczmarz basis (wal-functions)
// the wal functions are sequency- ordered
//
{
    const ulong n=(1<<ldn);

    gray_scramble(f,n);

    scramble(f,n);

    dit2_walsh_wak(f,ldn);
}
// ================= end DIT2_WALSH_WAL ==================


void 
dit2_walsh_wal0(double *f, ulong ldn)
//
// transform wrt. to walsh-kaczmarz basis (wal-functions)
// the wal functions are sequency- ordered
//
{
    const ulong n=(1<<ldn);

    //    gray_scramble0(f,n);
    gray_scramble(f,n);

    scramble(f,n);

    dit2_walsh_wak(f,ldn);
}
// ================= end DIT2_WALSH_WAL ==================


void 
dit2_walsh_pal(double *f, ulong ldn)
//
// transform wrt. to walsh-paley basis (pal-functions)
//
{
    ulong n=(1<<(ulong)ldn);

    scramble(f,n); 

    dit2_walsh_wak(f,ldn);
} 
// ============= end DIT2_WALSH ===============


void 
dit2_walsh_pal0(double *f, ulong ldn)
{
    ulong n=(1<<(ulong)ldn);

    scramble0(f,n); 

    dit2_walsh_wak(f,ldn);
} 
// ============= end DIT2_WALSH ===============


void 
dit2_walsh_wak(double *f, ulong ldn)
//
// transform wrt. to walsh-kronecker basis (wak-functions)
//
{
    ulong n=(1<<(ulong)ldn);

    for(ulong ldm=1; ldm<=ldn; ++ldm)
    {
        ulong m=(1<<ldm);
	ulong mh=(m>>1);

        for (ulong j=0; j<mh; ++j)
        {
            for (ulong r=0; r<n; r+=m)
            {
                ulong t1=r+j;
                ulong t2=t1+mh;

		double v=f[t2];
                double u=f[t1];

                f[t1]=u+v;
                f[t2]=u-v;
            }
        }
    }
} 
// ============= end DIT2_WALSH_WAK ===============
