
#include "fxtaux.h"
#include "fxt.h"

#define WALSH(f,n)   dit2_walsh_wal(f,ld(n))
#define WALSH0(f,n)  dit2_walsh_wal(f,ld(n))

void 
wide_walsh(double *f, ulong n, ulong d, double *w)
//
// compute walsh of the n elements 
// [0],[d],[2d],[3d],...,[(n-1)*d]
//
{
    ulong k,j;

    for(k=0,j=0; k<n*d; k+=d,j++)  // fill workspace
    {
        w[j]=f[k];
    }

    WALSH(w,n);             // do WALSH

    for(k=0,j=0; k<n*d; k+=d,j++)  // write back
    {
        f[k]=w[j];
    }
}
// =============== end WIDE_WALSH =========== 

void 
wide_walsh0(double *f, ulong n, ulong d, double *w)
//
// compute walsh of the n elements 
// [0],[d],[2d],[3d],...,[(n-1)*d]
//
{
    ulong k,j;

    for(k=0,j=0; k<(n*d)/2; k+=d,j++)  // fill workspace
    {
        w[j]=f[k];
    }

    for( ; k<n*d; j++)  // fill in zeros
    {
        w[j]=0.0;
    }


    WALSH0(w,n);             // do WALSH


    for(k=0,j=0; k<n*d; k+=d,j++)  // write back
    {
        f[k]=w[j];
    }
}
// =============== end WIDE_WALSH0 ===========

