
#include <stdlib.h>  // for exit()


#include "examples.h"


#define APPLICATION_USAGE(x)   examples_usage(x)

#define DO_APPLICATION(n,arg2,argv0) do_examples(n,arg2,argv0)


#include "main.inc"

#include "../src/include/hfloatfu.h"
#include "../src/include/hfdata.h"
#include "../src/include/hfverbosity.h"



void
do_examples(long n, int arg2, const char *argv0)
{
    char *fname;
    int binsaveq;
    hfloat r(n);    // for the result

    //    hfverbosity::hush_all();  // do not echo any operations
    hfverbosity::tell_all();  // echo all operations

//    cout<<" precision of result will be="<< r.prec() <<" LIMBS ";
//    cout<<" =="<< r.dec_prec() <<" decimal digits" << endl;

    binsaveq=hfdata::rx2pw;  // if radix=2^x then binsave

    if(binsaveq)  fname="result.bin";
    else          fname="result.txt";

    start_timer();

    // ---------
    if( arg2>=50 && arg2 <60 )
    {
        cout << " pi_arctan(r,arg2):" << endl;
	pi_arctan(r,arg2);
    }
    else
    {
	switch(arg2)
	{
	case 0:   cout << " pi_4th_order(r,0):" << endl;
            pi_4th_order(r,0);  break;

	case 1:   cout << " pi_4th_order(r,1):" << endl;
            pi_4th_order(r,1);  break;

	case 2:   cout << " pi_2nd_order(r):" << endl;
            pi_2nd_order(r);  break;

	case 3:   cout << " pi_agm(r,0):" << endl;
            pi_agm(r,0);  break;

	case 4:   cout << " pi_agm3(r,1):" << endl;
            pi_agm3(r,1);  break;

	case 5:   cout << " pi_agm3(r,-1):" << endl;
            pi_agm3(r,-1);  break;

	case 6:   cout << " pi_derived_agm(r):" << endl;
            pi_derived_agm(r);  break;

	case 7:   cout << " pi_5th_order(r):" << endl;
            pi_5th_order(r);  break;

	case 8:   cout << " pi_3rd_order(r):" << endl;
            pi_3rd_order(r);  break;

	case 9:   cout << " pi_9th_order(r):" << endl;
            pi_9th_order(r);  break;

	case 10:  cout << " pi_cubic_agm(r):" << endl;
            pi_cubic_agm(r);  break;

	case 13:  cout << " pi_agm(r,1):" << endl;
            pi_agm(r,1);  break;

	case 14:  cout << " pi_agm3(r,4):" << endl;
            pi_agm3(r,4);  break;

	case 15:  cout << " pi_agm3(r,-4):" << endl;
            pi_agm3(r,-4);  break;

	case 100: cout << " euler_e(r):" << endl;
            euler_e(r);  break;             // 2.718281828459045...

	case 101: cout << " euler_e_series(r):" << endl;
            euler_e_series(r);  break;      // 2.718281828459045...

	case 111: cout << " log2(n,r):" << endl;
            log2(n,r);  break;          // log(2)=0.6931471...

	case 163: cout << " exp_pi163(n,r):" << endl;
            exp_pi163(n,r);  break;     // exp(pi*sqrt(163))

	case 999: cout << " your_stuff(n,r):" << endl;
            your_stuff(n,r);  break;      //  <--- your code in yourstuff.cc

	default:  { examples_usage(argv0); exit(0); }  // usage info
	}
    }
    // ---------

    cout << " done. " << endl;

    //    if(arg2<99)  r-=3;  // fractional part of pi

    // save result:
    if(binsaveq) binsave_limbs(fname,r);
    else         save(fname,r);

    cout<<"\n result saved to file "<<fname<<"\n"<<flush;

    print("\n RESULT:\n",r,MIN(16,r.prec()));
    cout<<" precision="<<r.prec()<<" LIMBS =="
        << r.dec_prec() <<" decimal digits";

    print_last("\n last digits are:\n", r, 16);

    cout << "\n --------------- computation done -------------- ";
    cout << "\n  total elapsed time: " << return_elapsed_time() 
         << " seconds " << endl;

}
//================ end DO_EXAMPLES  ====================




void
examples_usage(const char *argv0)
{
    cerr<<
	"\n   second arg chooses what to do "
	<<endl;

    cerr<<
	"\n   ----- computation of pi: -----"
	"\n   0 => quartic iteration with r=4 (default) "
	"\n   1 => quartic iteration with r=16 "
	"\n   2 => 2.order iteration "

	"\n   3 => agm iteration "
	"\n   4 => agm3 iteration, faster variant "
	"\n   5 => agm3 iteration, slower variant "

	"\n   6 => derived agm iteration, (slow) "
	"\n   7 => quintic iteration (very slow) "
	"\n   8 => 3.order iteration "
	"\n   9 => 9.order iteration "

	"\n  10 => cubic agm iteration "

	"\n  13 => agm iteration, quartic variant "
	"\n  14 => agm3 iteration, quartic faster variant "
	"\n  15 => agm3 iteration, quartic slower variant "

	"\n  5N => N-term arctan series (N=2...7) (for modest precision) "
	"\n "
	"\n  e.g.: " << argv0 << " 11 1 65536 "
	"\n    use method 1, precision= 2^11=2048 (radix 65536) LIMBs "
	"\n    (i.e. precision is 2048*16 bits= 4096 bytes) "
	"\n  e.g.: " << argv0 << " 8 0 10000  (default action)"
	"\n    use method 0, precision= 2^8=256 (radix 10000) LIMBs "
	"\n    (i.e. precision is 256*4=1024 decimal digits) "
	"\n  e.g.: " << argv0 << " 14 "
	"\n    (precision is 2^15*4=128k decimal digits) "
	<<endl;

    cerr<<
	"\n   ----- other computations: -----"
	"\n   second arg chooses constant to be computed "
	"\n  100 => eulers e  (2.7182818...) via exp(1)"
	"\n  101 => eulers e  (2.7182818...) via series"

	"\n  111 => log(2)    (0.693147...) "

	"\n  163 => exp(pi*sqrt(163)) "

	"\n  999 => (your) stuff in yourstuff.cc "
	<<endl;
}
//================ end EXAMPLES_USAGE ====================


