//
// simple example 2: 
// compute pi with 2 different algorithms
//

#include  "../src/include/hfloatfu.h"
#include  "../src/include/mybuiltin.h"  // for timing


int main()
{
    // precision in LIMBs, use o power of two:
    hfloat::max_prec(2048);

    // radix, use 10000 (decimal) or 65536 (hex numbers):
    hfloat::radix(10000);


    hfloat pi1, pi2, d;
    double dt1, dt2;     // for timing

    // first pi computation:
    start_timer();
    pi_4th_order(pi1);  // compute pi using borweins quartic algorithm
    dt1 = return_elapsed_time();
    print("\n pi1=\n", pi1, 44); // print the first 44 LIMBs of pi1 
    print_last("\n last digits are \n", pi1, 16); // print the last 16 LIMBs
    save("pi1.dat",pi1);  // save pi1 to file "pi1.dat"


    // second pi computation:
    start_timer();
    pi_agm(pi2);  // compute pi using the agm algorithm
    dt2 = return_elapsed_time();

    /* // you can choose from these, cf. src/pi/pi*.cc:
    pi_4th_order(pi2, var);  // var = 0,1
    pi_5th_order(pi2);
    pi_agm(pi2,var);         // var = 0,1
    pi_agm3(pi2,var);        // var = +1,-1,+4,-4
    pi_2nd_order(pi2);
    pi_derived_agm(pi2);
    pi_3rd_order(pi2);
    pi_9th_order(pi2);
    pi_cubic_agm(pi2);
    pi_arctan(pi2, fno);     // fno = 2,3,4,5,6,7,11
    */

    print("\n pi2=\n", pi2, 44);
    print_last("\n last digits are \n", pi2, 16);
    save("pi2.dat",pi2);  // save pi2 to file "pi2.dat"


    cout << "\n pi1 took " << dt1 << " seconds ";
    cout << "\n pi2 took " << dt2 << " seconds ";


    d =  pi1;
    d -= pi2;

    cout << "\n\n decimal precision of the results is "
         << pi1.dec_prec() << " digits "
         << endl;

    print("\n difference of the results: p1-p2= \n",d,8);

    long dl = pi1.prec()-ABS(cmp_limbs(pi1,pi2)); 
    cout << "\n i.e. the last " << dl << " LIMBs disagree " << endl;


    return 0;
}
//---------------
