// operations with arrays of doubles and files


#include <iostream.h>
#include <assert.h>


#include "auxk.h"
#include "mybuiltin.h"
#include "verbose.h"  // disk function verbosity


#define PR(x)   // for debug

void file_report(FILE *f);


// # of elements read/written so far
double totio=0;



void kd_copy(FILE *f, long pos, double *d, long n)
//
// read doubles from disk
//
{
    verbose(8,".");

    PR( cout<<"\n R["<<(int)f<<"]("<<d<<", "<<pos<<" +"<<n<<")"<<flush; )    

    long i;
    i=fseek(f,pos*sizeof(double),SEEK_SET);
    assert(i==0);

    i=fread(d,sizeof(double),n,f);
    assert(i==n);

    totio+=n;
}
//================ end KD_COPY ===============



void dk_copy(FILE *f, double *d, long pos, long n)
//
// write doubles to disk
//
{
    verbose(8,",");

    PR( cout<<"\n W["<<(int)f<<"]("<<d<<", "<<pos<<" +"<<n<<")"<<flush; )    

    long i;
    i=fseek(f,pos*sizeof(double),SEEK_SET);
    assert(i==0);

    i=fwrite(d,sizeof(double),n,f);
    assert(i==n);

    totio+=n;
}
//================ end DK_COPY ===============



void dk_debug(FILE *f, long pos, double *d, long n,
                   double *wram, long wramsz, long fs)
{
    assert(pos<fs);
    assert(n<=wramsz);  
    assert(pos+n<=fs);  
    assert(d>=wram);
    assert(d+n<=wram+wramsz);

    dk_copy(f,pos,d,n);
}
//================ end DK_DEBUG ===============



void kd_debug(FILE *f, long pos, double *d, long n,
                   double *wram, long wramsz, long fs)
{
    assert(pos<fs);
    assert(n<=wramsz);  
    assert(pos+n<=fs);  
    assert(d>=wram);
    assert(d+n<=wram+wramsz);

    kd_copy(f,pos,d,n);
}
//================ end KD_DEBUG ===============



void file_report(FILE *f)
{
    cerr<<"\n ftell ="<<ftell(f);
    cerr<<"\n feof  ="<<feof(f);
    cerr<<"\n ferror="<<ferror(f);

    if(ferror(f))
    {
        cerr<<"\n\n second try ...";
	clearerr(f);
	cerr<<"\n ftell ="<<ftell(f);
	cerr<<"\n feof  ="<<feof(f);
	cerr<<"\n ferror="<<ferror(f);
    }
}
//================ end FILE_REPORT ===============


void kd_print(char *bla, FILE *f, long n)
{
    long i,j;
    double t;

    cout<<bla;

    j=fseek(f,0,SEEK_SET);

    assert(j==0);

    for(i=0; i<n; ++i)
    {
       j=fread(&t,sizeof(double),1,f);
       assert(j);
       cout<<t<<", ";
       if(i%8==7) cout<<"\n";
    }
}
//================ end KD_PRINT ===============


