
#include <assert.h>

#include "hfgutsfu.h"
#include "auxid.h"
#include "mybuiltin.h"
#include "verbose.h"

//#if RADIX_IS_TWO_POW
//#define RADIX_TIMES(x) (x<<LOG2RADIX)
//#else
#define RADIX_TIMES(x) (x*rx)
//#endif

#undef UINTX
#define UINTX unsigned long long


int i_div_semi(LIMB *cd, long cn, unsigned b, int &r)
{
    const UINTX rx=hfdata::rx;
    long k;
    UINTX zz;
    unsigned rem=0;

    for(k=0; k<cn; ++k)
    {
/*
        zz =   (UINTX)cd[k];
	zz +=  RADIX_TIMES(rem);
        cd[k]= (LIMB)(zz/b);
        rem  = zz%b;
*/
        zz =   (UINTX)cd[k];
	zz +=  (rem*rx);
        cd[k]= (LIMB)(rem=(zz/b));
        rem  = zz-b*rem;
    }


    k=0;
    while( 0==cd[k] )
        ++k;

    int f=k;

    if(k)   // normalize 
    {
        i_shift_left(cd,cn,k);
	
	do
	{
	    zz=RADIX_TIMES(rem);
	    cd[cn-k]=(LIMB)(zz/b);
	    rem=zz%b;
	}
	while(--k);
    }

    r=(int)rem;

    return f;
}
//================== end I_DIV_SEMI ========================


int hf_div_semi(const hfguts &a, long b, hfguts &c)
//
// c=a/b
// returns rem=a%b
//
{
    verbose(2,'\\');
    assert(c.writeable());
    assert(b!=0);

    int rem;

    c.sg=a.sg*SIGN(b);
    c.ex=a.ex;

    b=ABS(b);

    if( !hf_same_data(a,c) )
    {
        hf_copy(a,c);
    }


    int dx=i_div_semi(c.data->dig(),c.prec(),(unsigned)b,rem);
    c.ex-=dx;

    return (int)rem;
}
//================== end HF_DIV_SEMI ========================
