
#include <math.h>
#include <iostream.h>
#include <assert.h>
#include <stdlib.h>

#include "hfloatfu.h"
#include "mybuiltin.h"
#include "iteratio.h"

// for debugging:
#define PR(x)
#define SHRT 16


int
inv_iteration(const hfloat &di, hfloat &x, ulong startprec)
{
    return iroot_iteration(di,1,x,startprec);
}


/*
int
inv_iteration(const hfloat &di, hfloat &x, ulong startprec)
//
//   the equation 1/d==x/(1-(1-x*d)) = x*(1+y+y^2+y^3+...)
//   (where y:=(1-d*x), cf. iteration for inverse nth root)
//   gives the
//
//   iteration for 1/d:
//
//   x <- x+x(1-x*d)=2x-x^2*d=x*(2-x*d)
//   or:
//   x+= x*(1-d*x)
//
{
    int ret=0;
    int j;
    int xe, xs;
    ulong dp0 = di.prec();
    ulong prec,newprec;
    ulong precgoal = x.prec();
    ulong n;
    hfloat t(precgoal,0);
    hfloat d(di);   // clone

    if ( same_mantissa(d,x) )  d.make_own_data(d.prec());


    assert(!d.is_zero());           // div by zero

    PR( print("\n got d=",d,MIN(d.prec(),12)); );


    if (BREAK_COND(startprec))  return ret;

    xs=d.sign();
    d.sign(+1);           // remove sign for calculation

    xe=d.exp();
    d.exp(0);            // remove (big) exponents for calculations


    if (startprec<PREC_THRES)
    {
        approx_pow(d,x,-1.0);

        n=START_CALC_PREC;
        t.prec(n);
        x.prec(n);
        d.prec( MIN(n,dp0) );

        j=0;
        do
        {
                                  PR( print("\n x=",x,SHRT); );
            mul(x,d,t);           PR( print("\n x*d=",t,SHRT); );
            newprec=cmp1(t);     PR( cout.form("\n => newprec=%d",newprec); );
            sub(1,t,t);          PR( print("\n y:=(1-x*d)=",t,SHRT); );
            mul(x,t,t);          PR( print("\n x*y=",t,SHRT); );
            add(x,t,x);                //PR( print("\n x+x*(1-x*d)=",x,SHRT); );

            //            PREC_INFO(newprec,n);

            if ( ++j>20 )  ITER_ERR_1(j,"inv");
        }
        while(newprec < PREC_THRES/2);
    }
    else
    {
        approx_pow(d,t,-1.0);
        x.exp(t.exp());            // exponent for result

        newprec=startprec;
        n=START_PREC2;
        t.prec(n);
        x.prec(n);
        d.prec( MIN(n,dp0) );

        //        PREC_INFO(newprec,n);
    }


    prec=0;
    for(j=0; j<MAX_REC; ++j)  // ---------------- ITERATION --------------
    {
        //        PREC_INFO(newprec,n);
        OOOPSQ(newprec,n);

	n=MIN(2*n,precgoal);
        t.prec(n);
        x.prec(n);
        d.prec( MIN(n,dp0) );

                       PR( print("\n x=",x,SHRT); );
        mul(x,d,t);    PR( print("\n x*d=",t,SHRT); );
        sub(1,t,t);    PR( print("\n y:=(1-x*d)=",t,SHRT); );

        prec=newprec;
        newprec=-t.exp();     PR( cout.form("\n => newprec=%d",newprec); );

        if (BREAK_COND(newprec))
	{
            //            PREC_INFO(newprec,n);
            break;
	}

        if (THIRD_COND)
        {
	    aux_third(t,1);     PR(cout<<"\n third_order_correction "; );
            mul(t,x,t);         PR( print("\n x*(y+y^2)=",t,SHRT); );
        }
        else
	{
	    mul(t,x,t,n/2,n/2,n);     PR( print("\n x*y=",t,SHRT); );
	}


        add(x,t,x);                   PR( print("\n x+x*(y[+y^2])=",x,SHRT); );

	if (!CHECK_LAST_STEP)  if (EARLY_COND)  break;
    }
    // ---------------- end of ITERATION ---------------------

    assert(newprec > (precgoal/3));

    if (j==MAX_REC)  ITER_ERR_2(j,"inv");


    x.sign(xs);              // sign of result
    x.exp(1-xe);             // exponent of result

    return ret;
}
//============================= end INVERSE_ITERATION =========================
*/
