
#include <math.h>
#include <iostream.h>
#include <assert.h>
#include <stdlib.h>

#include "hfloatfu.h"
#include "mybuiltin.h"
#include "iteratio.h"


// for debug:
#define PR(x)
#define SHRT 12



int
isqrt_iteration(const hfloat &di, hfloat &x, ulong startprec)
{
    return iroot_iteration(di,2,x,startprec);
}

/*
int
isqrt_iteration(const hfloat &di, hfloat &x, ulong startprec)
//
//   the equation
//   1/sqrt(d)= x*1/sqrt(1-y)=x*(1+y/2+3/8*y^2+5/16*y^3+...)
//   (where y:=(1-d*x^2), cf. iteration for inv nth root)
//   gives the
//   iteration for 1/sqrt(d):
//
//   x <- x*(3-x*x*d)/2
//   or:
//   x+= x*(1-d*x^2)/2
//
{
    int ret=0;
    int j;
    int xe;
    ulong dp0 = di.prec();
    ulong prec,newprec;
    ulong precgoal = x.prec();
    ulong n;
    hfloat t(precgoal,0);
    hfloat d(di);   // clone

    if ( same_mantissa(d,x) )  d.make_own_data(d.prec());

    PR( print("\n\n isqrt_iter: d== \n",d,SHRT); );

    if ( BREAK_COND(startprec) )  return ret;


    assert(d.positive());     // error: neg sqrt

    xe=(d.exp()/2)*2;
    d.exp(d.exp()-xe);        // remove (big) exponent for calculations


    if (startprec<PREC_THRES)
    {
        n=START_CALC_PREC;
        t.prec(n);
        x.prec(n);
        d.prec( MIN(n,dp0) );
        approx_pow(d,x,-0.5);
                                PR( print("\n\n pre-loop: x_0= \n",x,SHRT); );
        j=0;
        do
        {
                            PR( print("\n\n pre-loop: x= \n",x,SHRT); );
            sqr(x,t);       PR( print("\n pre-loop: x^2= \n",t,SHRT); );
            mul(t,d,t);     PR( print("\n pre-loop: x^2*d= \n",t,SHRT); );
            newprec = cmp1(t,0);
            sub(1,t,t);     PR( print("\n pre-loop: y:=(1-x^2*d)= \n",t,SHRT); );
            mul(x,t,t);     PR( print("\n pre-loop: x*y= \n",t,SHRT); );
            div2(t,t);      PR( print("\n pre-loop: x*y/2= \n",t,SHRT); );
            add(x,t,x);     PR( print("\n pre-loop: x+x*y/2= \n",x,SHRT); );

            //            PREC_INFO(newprec,n);

            if ( ++j>=20 )  ITER_ERR_1(j,"isqrt");
        }
        while(newprec < PREC_THRES/2);
    }
    else
    {
        newprec=startprec;
        n=START_PREC2;
        t.prec(n);
        x.prec(n);
        d.prec( MIN(n,dp0) );

        //        PREC_INFO(newprec,n);
    }

    prec=0;
    for(j=0; j<MAX_REC; ++j) // ------------ ITERATION ------------------
    {
        //        PREC_INFO(newprec,n);
        OOOPSQ(newprec,n);

	n=MIN(2*n,precgoal);

        t.prec(n);
        x.prec(n);
        d.prec( MIN(n,dp0) );

                       PR( print("\n  x= \n",x,SHRT); );
        sqr(x,t);      PR( print("\n  x^2= \n",t,SHRT); );
        t*=d;          PR( print("\n  d*x^2= \n",t,SHRT); );
        sub(1,t,t);    PR( print("\n y:=(1-x^2*d)= \n",t,SHRT); );
        t/=2;          PR( print("\n y/2= \n",t,SHRT); );

        prec=newprec;
        newprec=-t.exp(); PR( cout.form("\n new precision: (%d) ",newprec); );

        if (BREAK_COND(newprec))
        {
            //            PREC_INFO(newprec,n);
            break;
        }


        if (THIRD_COND)
        {
            aux_third(t,2);   PR(cout<<"\n third_order_correction "; );
            t*=x;             PR( print("\n = \n",t,SHRT); );
        }
        else
	{
	    mul(t,x,t,t.prec()/2,x.prec()/2,t.prec());     PR( print("\n x*y/2=",t,SHRT); );
	}

        x+=t;                 PR( print("\n x+x*y/2= \n",x,SHRT); );


	if (!CHECK_LAST_STEP)  if (EARLY_COND)  break;
    }
    // ---------------- end of ITERATION ---------------------

    assert(newprec > (precgoal/3));

    if ( j==MAX_REC )  ITER_ERR_2(j,"isqrt");

    x.exp(x.exp()-xe/2);            // exponent of result

    return ret;
}
// ================ end INVERSE_SQUARE_ROOT_ITERATION ================
*/
