
#include <math.h>
#include <iostream.h>
#include <stdlib.h>
#include <assert.h>

#include "hfloatfu.h"
#include "auxid.h"
#include "mybuiltin.h"
#include "radix.h"
#include "verbose.h"


#define PR if(0)


#define UINT64  unsigned long long int



int direct_mul_semi_short(const hfloat &a, int b, hfloat &c)
//
// c=a*b (or c*=b)
//
// needs NOT to be: b < RADIX !!!
//
// must be an <= length(c) !
//
// return: sign of result
//
{
int an,cn;
int k;
UINT64 zz,cy;


verbose(2,"*");


    if(a.is_zero() || b==0)
    {
        c.set_zero();
        return 0;
    }

    c.sign(a.sign()*SIGN(b));
    c.exp(a.exp());

    b*=SIGN(b);
//    assert(b<RADIX);

    an=a.prec();
    cn=c.prec();

    cy=0;

    if(a.digit!=c.digit)
    {
/*
        for(k=an-1; k>=0; --k)           // low to high
        {
            zz=(UINT64)a.digit[k]*b+cy;
            c.digit[k]=IMODRAD(zz);
            cy=IDIVRAD(zz);
        }
*/
        copy(a,c);

    }
/*    else                                 // c*=b
*/
    {
        for(k=cn-1; k>=0; --k)           // low to high
        {
            zz=(UINT64)c.digit[k]*b+cy;
            c.digit[k]=IMODRAD(zz);
            cy=IDIVRAD(zz);
        }
    }


    if(cy!=0.0)
    {
        i_shift_right(c.digit,cn);
        c.digit[0]+=cy;
        c.exp(c.exp()+1);
    }


return c.sign();
}
//=============== end DIRECT_MULTIPLY_SEMI_SHORT ==================


