
#include <math.h>
#include <iostream.h>
#include <assert.h>
#include <stdlib.h>

#include "hfloatfu.h"
#include "mybuiltin.h"


// for debug :
#define PR(x) 


int pow_geq_3(const hfloat &a, int ex, hfloat &c)
//
// c=a^ex
// exponent >= +3 
//
{
    assert( ex>=3 );

    int firstq;

    if( ex==(1<<ld(ex)) ) // special case ex==2^n
    {
        sqr(a,c);

        while((ex/=2)!=1)
        {
            sqr(c,c);
        }

	verbose(1,"] ");

        return 0;
    }


    firstq=1;

    hfloat t(c.prec(),0);

    copy(a,t);

    while(1)
    {

        if(ex&1)  // odd
        {
            if(firstq)     // avoid multiplication with 1
            {
                copy(t,c);
                firstq=0;
            }
            else
	    {
                mul(c,t,c);
	    }

            if(ex==1)
                break;
        }

	sqr(t,t);

	ex/=2;
    }

    return 0;
}
// ========================== end POWER_GEQ_3 ==============================
