
#include <math.h>
#include <assert.h>

#include "hfdatafu.h"
#include "workspace.h"
#include "auxid.h"
#include "mybuiltin.h"


int i_add_to(LIMB *rd, ulong rn, ulong dx, const LIMB *ad, ulong an,
             const unsigned rx);

int
dt_add(const hfdata &big, ulong bp, const hfdata &sml, ulong sp, 
       ulong dx, hfdata &c, ulong cp)
//
// returns last carry (increment for exponent)  (0 or 1)
// uses workspace
//
{
    ulong  rn;
    int   i;
    LIMB *rd;

    rn = MAX3(bp, sp, cp);

    rd = gws.get_ws_limbs(rn);

    i_copy(big.dig(), bp, rd, rn);

    i = i_add_to(rd, rn, dx, sml.dig(), sp, hfdata::rx);
	
    if ( 0==i )
    {
        i_copy(rd, rn, c.dig(), cp);
    }
    else
    {
        i_copy(rd, rn, c.dig()+1, cp-1);
	c.dig()[0] = 1;
    } 

    gws.let_ws(rd);

    return i;
}
//===================== end DT_ADD =====================



int
i_add_to(LIMB *rd, ulong rn, ulong dx, const LIMB *ad, ulong an,
         const unsigned rx)
//
// returns last carry (0 or 1)
//
{
    long k;
    long m = MIN(dx+an, rn);

    unsigned cy=0; 
    for (k=m-1; k>=(long)dx; --k)
    {
        unsigned rk = rd[k]+ad[k-dx]+cy;

        if ( rk>=rx )
        {
	    rk -= rx;
            cy = 1;
        }
        else
        {
            cy = 0;
        }

	rd[k] = (LIMB)rk;
    }

    for ( ; (k>=0) && (cy!=0) ; --k)
    {
        unsigned rk = rd[k]+cy;

        if ( rk>=rx )
        {
	    rk -= rx;
            cy = 1;
        }
        else
        {
            cy = 0;
        }

	rd[k] = (LIMB)rk;
    }

    return cy;
}
//===================== end I_ADD_TO =====================
