
#include <math.h>
#include <assert.h>

#include "hfdatafu.h"
#include "auxid.h"
#include "workspace.h"


//#if RADIX_IS_TWO_POW
//#define IMODRAD(x,rx)     ((LIMB)(x & NINE))
//#define IDIVRAD(x,rx)     (x>>LOG2RADIX)
//#else
#define IMODRAD(x,rx)     ((LIMB)(x%rx))
#define IDIVRAD(x,rx)     (x/rx)
//#endif


int i_mul_slow(const LIMB *ad, ulong an, const LIMB *bd, ulong bn,
               LIMB *cd, ulong cn, const unsigned rx);


int
dt_mul_slow(const hfdata &a, ulong ap, const hfdata &b, 
            ulong bp, hfdata &c, ulong cp)
{
    const unsigned rx=hfdata::rx;

    // take care that loops are localized:
    if ( ap<bp )  return i_mul_slow(a.dig(), ap, b.dig(), bp, c.dig(), cp, rx);
    else          return i_mul_slow(b.dig(), bp, a.dig(), ap, c.dig(), cp, rx);

}
//===================== end DT_MUL_SLOW ================================


int
dt_sqr_slow(const hfdata &a, ulong ap, hfdata &c, ulong cp)
{
    const unsigned rx=hfdata::rx;

    return i_mul_slow(a.dig(), ap, a.dig(), ap, c.dig(), cp, rx);
}
//===================== end DT_SQR_SLOW ================================


int
i_mul_slow(const LIMB *ad, ulong an, const LIMB *bd, ulong bn,
           LIMB *cd, ulong cn, const unsigned rx) 
{
    int ret;
    long k, j;
    ulong rn;
    LIMB *rd;

    /*
    if( an>bn )
    {
        SWAP(ad,bd);
	SWAP(an,bn);
    }
    */
    
    rn=an+bn+1;
    rd=gws.get_ws_limbs(rn);
    i_null(rd,rn);

    for(j=bn-1; j>=0; --j)
    {
        long i=0;
	unsigned int zz, cy=0;

        for(k=an-1, i=k+j+1;   ; --k,--i)
        {
            //	    assert(k>=0); assert((ulong)k<an);
            //	    assert(j>=0); assert((ulong)j<bn);
            //	    assert(i>=0); assert((ulong)i<rn);

            //            i = k+j+1;
            zz = (unsigned int)(rd[i]+ad[k]*bd[j]+cy);
            rd[i] = IMODRAD(zz,rx);
            cy =    IDIVRAD(zz,rx);

	    if( k==0 )  break;
        }

        for( --i ; i>=0 && cy!=0 ; --i)
        {
            //            assert( i>=0 ); assert( (ulong)i<rn );

            zz = (unsigned int)(rd[i]+cy);
            rd[i] = IMODRAD(zz,rx);
            cy =    IDIVRAD(zz,rx);
        }
    }


    if(rd[0]==0)   // no overflow ?
    {
        i_copy(rd+1, rn-1, cd, cn);
	ret = 0;
    }
    else
    {
        i_copy(rd, rn, cd, cn);
        ret = 1;
    }

    gws.let_ws(rd);

    return ret;
}
//===================== end I_MUL_SLOW ================================
