
#include <math.h>
#include <assert.h>
#include <Complex.h>

#include "fxtaux.h"


#define RX 4
#define LX 2


void 
dif4l_fft(double *fr, double *fi, ulong ldn, int is)
//
// non-optimized learners version of radix 4 fft
// uses type Complex
//
{
    ulong ldm,m,m4;
    ulong j,r;
    ulong i0,i1,i2,i3;

    double ph0,phi,c,s,c2,s2,c3,s3;

    Complex a0,a1,a2,a3;
    Complex e,e2,e3;
    Complex t0,t2;
    Complex t1,t3;

    const ulong n=(1<<ldn);

    for(ldm=ldn; ldm>=LX; ldm-=LX)
    {
        m=(1<<ldm);
        m4=(m>>LX);
        ph0=(is>0?2.0*M_PI:-2.0*M_PI)/m;

        for(j=0; j<m4; j++)
        {
            phi=j*ph0;
            sincos(&c,&s,phi);
            sincos(&c2,&s2,2.0*phi);
            sincos(&c3,&s3,3.0*phi);
 
            e =Complex(c,s);
            e2=Complex(c2,s2);
            e3=Complex(c3,s3);

            for(r=0, i0=j+r; r<n; r+=m, i0+=m)
            {
                i1=i0+m4;
                i2=i1+m4;
                i3=i2+m4;

                a0=Complex(fr[i0],fi[i0]);
                a1=Complex(fr[i1],fi[i1]);
                a2=Complex(fr[i2],fi[i2]);
                a3=Complex(fr[i3],fi[i3]);
                

                t0=(a0+a2)+(a1+a3);
                t2=(a0+a2)-(a1+a3);

                t1=(a0-a2)+Complex(0,is)*(a1-a3);
                t3=(a0-a2)-Complex(0,is)*(a1-a3);

                t1*=e;
                t2*=e2;
                t3*=e3;

                TSWAP(Complex,a1,a2);

                fr[i0]=t0.real();
                fr[i1]=t1.real();
                fr[i2]=t2.real();
                fr[i3]=t3.real();

                fi[i0]=t0.imag();
                fi[i1]=t1.imag();
                fi[i2]=t2.imag();
                fi[i3]=t3.imag();
            }
        }
    }


    if( (ldn&1)!=0 )  // n is not a power of 4, need a radix 2 step
    {
        for(r=0; r<n; r+=2)
	{
            i0=r;
            i1=i0+1;

            a0=Complex(fr[i0],fi[i0]);
            a1=Complex(fr[i1],fi[i1]);

            t0=a0+a1;
            t1=a0-a1;

            a0=t0;
            a1=t1;

            fr[i0]=a0.real();
            fr[i1]=a1.real();
               
            fi[i0]=a0.imag();
            fi[i1]=a1.imag();
	}
    }

    scramble(fr,fi,n);
}
// ============================== end SANDE4L_FFT ==========================
