
#include <assert.h>

#include "fxt.h"
#include "fxtaux.h"


void 
fht_convolution(double *x, double *y, ulong ldn)
//
// convolve x[] with y[]
// data length=n=2^n
// result in y[]
// data in x[] is changed 
// x,y must not overlap im memory
// 
{
    assert( x!=y );

    fht(x,ldn);
    fht(y,ldn);

    fht_convolution_core(x,y,ldn);

    fht(y,ldn);
}
//================== end FHT_CONVOLUTION =================


void 
fht_convolution0(double *x, double *y, ulong ldn)
//
// same as fht_convolution(...)
// but for zero padded data
// (i.e. x[n/2,...,n-1] and y[n/2,....,n-1]
// are assumed to be zero, n=2^ldn)
//
{
    assert( x!=y );

    fht0(x,ldn);
    fht0(y,ldn);

    fht_convolution_core(x,y,ldn);

    fht(y,ldn);
}
//================== end FHT_CONVOLUTION0 =================


void 
fht_convolution_core(double *x, double *y, ulong ldn)
//
// x,y must not overlap
// 
// normalize done (with dn)
//
{
    const ulong   n = (1<<ldn);
    const ulong  nh = n/2;
    const double dn = (0.5/n);

    for (ulong i=1,j=n-1; i<nh; i++,j--)
    {
        double h1p = x[i];
        double h1m = x[j];

        double s1 = h1p+h1m;
        double d1 = h1p-h1m;

        double h2p = y[i];
        double h2m = y[j];
    
        y[i] = dn*(h2p*s1+h2m*d1);
        y[j] = dn*(h2m*s1-h2p*d1);
    }

    y[0]  *= 2.0*dn*x[0]; 
    y[nh] *= 2.0*dn*x[nh];
}
//================== end FHT_CONVOLUTION_CORE =================
