
#include "mfft.h"
//#include "modm.h"


void
mod_fft_dif2(mod *f, ulong ldn, int is)
//
// radix 2 decimation in frequency mod fft
//
{
    const ulong n = (1<<ldn);

    mod dw = mod::root2pow( is>0?ldn:-ldn );

    for(ulong ldm=ldn; ldm>1; --ldm)
    {
        const ulong m = (1<<ldm);
	const ulong mh = (m>>1);

	mod w = (mod::one);

        for(ulong j=0; j<mh; ++j)
        {
            for(ulong r=0; r<n; r+=m)
            {
                const ulong t1 = r+j;
                const ulong t2 = t1+mh;

                mod v = f[t2];
                mod u = f[t1];

                f[t1] += v;
                f[t2] = (u-v)*w;
            }

	    w *= dw;
        }

	dw *= dw;
    }

    sumdiff2(f,n);

    scramble(f,n);
}
// =============== end MOD_FFT_DIF2 =================

