
#include <math.h>

#include "fxtaux.h"


void slow_ht(double *f, ulong n)
//
// the original SHT (slow hartley transform)
// (may burn your FPU)
//
{
    double *res=new double[n];

    const double ph0=2.0*M_PI/n;

    for(ulong w=0; w<n; ++w)
    {
        double t=0.0; 

        for(ulong k=0; k<n; ++k)
	{
            double c,s;

            sincos(&c,&s,ph0*k*w);

            t += ((c+s)*f[k]);;
	}
   
        res[w] = t;
    }

    for(ulong k=0; k<n; ++k)  f[k]=res[k];    

    delete [] res;
}
// ================== end SLOW_HT ====================
