#include <math.h>
#include <assert.h>

#include "hfgutsfu.h"
#include "hfdatafu.h"
#include "mybuiltin.h"


// for debug:
#define PR(x) 
#define PRZ(x) 
#define PRAS(x) 
#define SHRT  4


#define SAFE(x)     // range asserts


#define ILN 64
static  hfguts big(0);
static  hfguts sml(0);
static  hfguts x(ILN);

int gt_addsub_int(const hfguts &a, long i, hfguts &c, int subq)
//
// subq determines the action: 
//    0: c=a+b
//   +1: c=a-b
//   -1: c=b-a
{
    assert( (subq==0) || (subq==+1) || (subq==-1) );


    x.prec(ILN);
    long p = gt_from_int(i,x);
    x.prec(p);


    if ( subq==-1 )  return gt_addsub(x,a,c,+1);
    else             return gt_addsub(a,x,c,subq);
}
//================== end GT_ADDSUB_INT ===================



int gt_addsub(const hfguts &a, const hfguts &b, hfguts &c, int subq)
// 
// 1.) any of a,b,c can be identical
// 2.) different exponents cause an offset in add/sub
// 3.) action is determined by the signs (of a and b) and subq
// 4.) any combination of precisions can occur
//
// subq determines the action: 
//    0: c=a+b
//   +1: c=a-b
//
{
    assert( c.writeable() );
    assert( (subq==0) || (subq==+1) );

#if FORBID_UNNORMALIZED
    assert( a.normalized() );
    assert( b.normalized() );
#endif // FORBID_UNNORMALIZED


    if ( a.is_zero() )  // a==0
    {
        if ( b.is_zero() )  // && b==0
        {
            c.set_zero();
        }
        else
        {
            c.copy(b);
            if ( subq==+1 )  c.negate();
        }

        return 0;
    }

    if(b.is_zero())  // b==0
    {
        c.copy(a);  // copy a!=0
        return 0; 
    }


    // -------- a!=0 and b!=0:
    int i, chsg=0;
    int  sq;  // whether to subtract mantissas
    int  ds;  // diff. of signs
    long dx;  // diff. of exponents 
    
    dx = (long)(a.exp()-b.exp());  // problem if precisions fill a long 

    ds = ( a.sign()!=b.sign() );

    if ( ds )
    {
        sq = (!subq);
    }
    else
    {
        sq = subq;
    }

    if ( dx>0 )  // a>b
    {
        big.link(a);
	sml.link(b);
    }
    else         // b>a
    {
        if( subq && (ds^sq) ) 
	{
	    chsg=1;
	}
      
        big.link(b);
	sml.link(a);
    }

    dx=ABS(dx);

    /*
    if ( 0 ) //ABS(dx) > cprec() )
    {
        c.copy(big);
    }
    else
    */

    {
        if ( sq )    // SUBTRACT:
	{
	    i = dt_sub( *big.data(),big.prec(),
                        *sml.data(),sml.prec(), dx,
                        *c.data(),c.prec());

	    c.sign( i*big.sign() );
	    c.exp( big.exp() );
	}
	else      // ADD:
	{
	    i = dt_add( *big.data(),big.prec(),
                        *sml.data(),sml.prec(), dx,
                        *c.data(),c.prec());

	    c.sign( big.sign() );
	    c.exp( big.exp() );
	    c.exp( c.exp()+i );
	}
    }

    if ( chsg )  c.negate();
    

    sml.unlink();
    big.unlink();

    c.normalize();


#if FORBID_UNNORMALIZED
    assert( c.normalized() );
#endif // FORBID_UNNORMALIZED

    return 0;
}
//=========================== end GT_ADDSUB ==========================
