
#include <math.h>
#include <iostream.h>
#include <assert.h>

#include "hfgutsfu.h"
#include "hfdatafu.h"
#include "mybuiltin.h"


#define SMALL_DBL (1.0e-23)
#define LARGE_DBL (1.0e+23)

#define HUGE_EXP  307
#define HUGE_DBL  (1.0e+307)



int
gt_to_double(const hfguts &a, double &d)
{
    if ( a.is_zero() )
    {
        d = 0.0;
        return 0;
    }

    const double drx = (double)hfdata::rx;

    dt_mantissa_to_double(*a.data(),a.prec(),d);

    if ( log(d)+a.exp()*log(drx) > HUGE_EXP )
    {
        assert( 0*(int)*" overflow while converting to double " );
    }

    d *= a.sign();

    d *= pow(drx,(double)a.exp());

    return 0;
}
//===================== end GT_TO_DOUBLE =======================



ulong
gt_from_double(double d, hfguts &a)
//
// returns how many LIMBS were made
//
{
    assert( a.writeable() );

    if ( 0==d )
    {
        a.set_zero();
	return 1;
    }


    a.sign( SIGN(d) );
    d = fabs(d);

    assert( d<HUGE_DBL );


    const double drx  = (double)hfdata::rx;
    const double drx1 = 1.0/(double)hfdata::rx;
    long ex = 0;

    while ( d<1.0 )
    {
        d *= drx ;
        ex--;
    }

    while ( d>=1.0 )
    {
        d *= drx1 ;
        ex++;
    }
    a.exp( ex );


    //    cout << " DDDDD=" << d << endl;
    ulong k = dt_double_to_mantissa(d,a.prec(),*a.data());
    //    gt_dump("",a,0);

    a.normalize();

    return k;
}
//======================= end GT_FROM_DOUBLE =======================

