
#include <math.h>
#include <iostream.h>
#include <assert.h>

#include "hfgutsfu.h"
#include "hfdata.h"


#define SAFE(x) x    // range asserts


int
gt_ldexp(const hfguts &x, long p, hfguts &a)
{
    assert(a.writeable());

    if ( 0==p )
    {
        a.copy(x);
        return 0;
    }

    if (p>0)
    {
        if ( 1==p )  gt_mul2(x,a);
	else         gt_mul2pow(x,p,a);
    }
    else
    {
        if ( -1==p )  gt_div2(x,a);
	else          gt_div2pow(x,-p,a);
    }

    return 0;
}
//============== end GT_LDEXP ============


int
gt_mul2(const hfguts &x, hfguts &a)
//
// returns last carry
//
{
    assert(a.writeable());

    const int rx = hfdata::rx;
    const int nine = hfdata::rx-1;
    const int rxbits = hfdata::rxbits;

    long k; 
    unsigned long t,cy;
    LIMB *ad = a.data()->dig();

    a.copy(x);


    if ( hfdata::rx2pw )
    {
	t = 0;
	for (k=a.prec()-1; k>=0; --k)
	{
	    t |= (unsigned long)ad[k]<<1;
	    ad[k] = t&nine;
	    t >>= rxbits;
	}
    
	if ( t!=0 )
	{
            //	    i_shift_right(ad,a.prec());
            (*a.data()).shift_right(a.prec(),1);
	    ad[0] = 1;
	    a.exp( a.exp()+1 );
	}
	cy = t; 
    }
    else
    {
	cy = 0;
	for (k=a.prec()-1; k>=0; --k)
	{
	    t = ((unsigned long)ad[k]<<1)+cy;
    
	    if ( t>=(unsigned long)rx )
	    {
		cy = 1;
		ad[k] = t-rx;
	    }
	    else
	    {
		cy = 0;
		ad[k] = t;
	    } 
	}
    
	if ( cy!=0 )
	{
            //	    i_shift_right(ad,a.prec());
	    (*a.data()).shift_right(a.prec(),1);
	    ad[0] = 1;
	    a.exp( a.exp()+1 );
	}
    }

    return 1;
}
//===================== end GT_MUL2 ================================


int
gt_mul2pow(const hfguts &x, unsigned long p, hfguts &a)
{
    assert(a.writeable());

    const unsigned int rxbits = hfdata::rxbits;

    unsigned long tt; 

    a.copy(x);

    if ( p==0 )  return 0;


    tt = p%rxbits;

    if ( tt!=0 )
    {
        if ( tt==1 )
	{
	    gt_mul2(a,a);
	}
	else
	{
            gt_mul_int(a,1<<tt,a);
        }
    }


    if ( p<rxbits )  return 0;
    else             tt = (p/rxbits);


    if ( hfdata::rx2pw )
    {
        a.exp( a.exp()+tt );
    }
    else
    {
        while( tt>0 )
	{
	    // mul by the biggest pow of 2 that is <= rx
	    gt_mul_int(a,1<<rxbits,a);
	    tt--;
	}
    }

    return 0;
}
//===================== end GT_MUL2POW ================================



int
gt_div2(const hfguts &x, hfguts &a)
//
// returns last carry
//
{
    assert( a.writeable() );

    const unsigned int rx = hfdata::rx;
    const unsigned int rxbits = hfdata::rxbits;

    ulong k;
    unsigned long cy,t;
    LIMB *ad = a.data()->dig();

    a.copy(x);


    if ( hfdata::rx2pw )
    {
	t=0;
        //	cy=0;   
	for (k=0; k<a.prec(); ++k)
	{
	    t |= ad[k];
	    cy = t&1;
	    ad[k] = t>>1;
	    t = cy<<rxbits;
	}
    }
    else
    {
	cy = 0;
	for (k=0; k<a.prec(); ++k)
	{
	    t = ad[k];
    
	    if ( cy!=0 )  t+=rx;
	    cy = t&1;
            ad[k] = (LIMB)(t>>1);
	}
    }

    if ( ad[0]==0 )
    {
        //        i_shift_left(ad,a.prec());
        (*a.data()).shift_left(a.prec(),1);
	a.exp( a.exp()-1 );
    }  


    return cy;
}
//===================== end GT_DIV2  ==============================



int
gt_div2pow(const hfguts &x, unsigned long p, hfguts &a)
//
// returns 
//
{
    assert( a.writeable() );

    const unsigned int rxbits = hfdata::rxbits;
    unsigned long tt;

    a.copy(x);

    if ( p==0 )  return 0;

    tt = p%rxbits;

    if ( tt!=0 )
    {
        if ( tt==1 )  gt_div2(a,a);
	else          gt_div_int(a,1<<tt,a);
    }

    if ( p<rxbits )  return 0;
    else             tt = (p/rxbits);


    if ( hfdata::rx2pw )
    {
        a.exp( a.exp()-p ); //div_by_raxdix_pow
    }
    else
    {
        while ( tt>0 )
	{
	    // div by the biggest pow of 2 that is <= rx
	    gt_div_int(a,1<<rxbits,a);
	    tt--;
	}
    }


    return 0;
}
//===================== end GT_DIV2POW ==============================


/*
int
gt_mul2(const hfguts &x, hfguts &a)
{
  gt_mul_int(x,2,a);
  return 0; 
}

int
gt_div2(const hfguts &x, hfguts &a)
{
  gt_div_int(x,2,a);
  return 0;
}

int
gt_mul2pow(const hfguts &x, int p, hfguts &a)
{
  assert(p<=30);
  gt_mul_int(x,(1<<p),a);
  return 0;
}

int
gt_div2pow(const hfguts &x, int p, hfguts &a)
{
  assert(p<=30);
  gt_div_int(x,(1<<p),a);
  return 0;
}
*/

