
#include <assert.h>
#include <iostream.h>
#include <math.h>

#include "hfguts.h"
#include "hfdata.h"

// for debug:
#define PR(x)
#define PRCD(x)  // print constr. and destr.

#define SAFE(x) x  // do check()s at constr. and link() 



double hfguts::overflow =+1000000000.0;  // biggest exponent, must fit into type long
double hfguts::underflow=-1000000000.0;  // smallest exponent, must fit into type long

long   hfguts::nguts=0;


hfguts::hfguts(ulong n)
//
// create a hfguts with new hfdata of n elements
//
{
    PRCD( cout<<"  "<< (void *)this<<"=hfguts("<<n<<") "; );

    nguts++;

    if ( n==0 )
    {
        dt = 0;
        dtwrtbl = 0;
    }
    else
    {
        dt = new hfdata(n);
	dt->addlink();
	dtwrtbl = 1; 
    }

    sg = 0;  // initialized to zero
    ex = 0;
    pr = n;
}
//--------------


hfguts::hfguts(LIMB *d, ulong n, int ro)
//
// create a hfguts with 
// new hfdata of n elements that uses n LIMBs at d
//
{
    PRCD( cout<<"  "<< (void *)this<<"=hfguts(d,n,ro) "; );

    nguts++;

    sg = 0;  // initialized to zero
    ex = 0;
    pr = n;

    dt = new hfdata(d,n);
    dt->addlink();    

    if ( ro )  dtwrtbl = 0;
    else       dtwrtbl = 1;
}
//--------------



hfguts::hfguts(const hfguts &h)
//
// create a hfguts with 
// new hfdata from existing hfdata
//
{
    PRCD( cout<<"  "<< (void *)this<<"=hfguts(h="<<(void*)&h<<") "; );
    //    hfguts(h,0,h.prec());

    nguts++;

    SAFE( h.check(); )
    sg = h.sg;
    ex = h.ex;

    pr = h.pr;
    dt = h.dt;

    dtwrtbl = 0;

    dt->addlink();    

    SAFE( check(); )
}
//--------------


/*
hfguts::hfguts(const hfguts &h, ulong n0, ulong p)
//
// create a hfguts with 
// new hfdata that uses p LIMBs after
// position n0 in existing hfdata
//
{
    PRCD( cout<<"  "<< (void *)this<<"=hfguts(h="<<(void*)&h<<",n0,p) "; );

    h.data()->addlink();

    assert( n0+p <= h.prec() );

    nguts++;

    SAFE( h.check(); )
    sg = h.sg;
    ex = h.ex;

    if ( p )  pr = p;
    else      pr = h.pr;

    if ( n0 )  dt = new hfdata(h.dt->dig()+n0, p);
    else       dt = h.dt;

    dtwrtbl = 0;

    dt->addlink();    

    SAFE( check(); )
}
//--------------
*/


hfguts::~hfguts()
{
    PRCD( cout<<"  "<< (void *)this<<": ~guts "; );

    unlink();

    nguts--;
}
//--------------


void
hfguts::unlink()
//
// unlink dt:
// forget hfdata
// and possibly delete it
//
{
    if ( dt )
    {
        if ( 0==(dt->sublink()) )  delete dt;  // delete dt if noone is looking anymore
	dt = 0;
    }
    
    dtwrtbl = 0;
}
//--------------


void
hfguts::link(const hfguts &h)
{
    SAFE( h.check(); )

    sg = h.sg;
    ex = h.ex;
    pr = h.pr;

    link(*h.dt,1);  // link read/only
    
    SAFE( check(); )
}
//--------------


void
hfguts::link(hfdata &dat, int ro)
//
// link dat 
// ro!=0  ==> readonly
//
{
    dt = &dat;
    dat.addlink();   // tell hfdata one more hfguts is looking

    if ( ro )  dtwrtbl = 0;
    else       dtwrtbl = 1;
    
    SAFE( check(); )
}
//--------------


int
hfguts::writeable() const
{
    return dtwrtbl;
} 
//--------------


void
hfguts::copy(const hfguts &g)
{
    if ( this==&g )  return;  // nothing to do

    assert( writeable() );

    sign(g.sign());
    exp(g.exp());

    if ( same_mantissa(g) )  return;  // nothing more to do

    data()->copy( *g.data(), prec());  // copy data
}
//--------------


int
hfguts::same_mantissa(const hfguts &g) const
{
    return ( (data()->dig()) == (g.data()->dig()) );
}
//--------------


ulong
hfguts::prec() const
{
    return pr;
}
//--------------


void
hfguts::prec(ulong p)
{
    if ( p<=(dt->size()) )  pr = p;
    else                    dt->size(p);
}
//--------------


int
hfguts::sign() const
{
    return sg;
}
//--------------


void
hfguts::sign(int s)
{
    assert( (s==+1) || (s==-1) || (s==0) );
    sg = s;
}
//--------------


int
hfguts::is_zero() const
{
    return  (sg==0);
}
//--------------


void
hfguts::set_zero()
{
    sg = 0;

    dt->fill(0);  // fill mantissa with zeroes
}
//--------------


double
hfguts::exp() const
{
    return ex;
}
//--------------


void
hfguts::exp(double x)
{
    assert( x>=underflow );
    assert( x<=overflow );
    ex = x;
}
//--------------


void
hfguts::negate()
{
    sg = -sg;
}
//--------------


int
hfguts::normalized() const
{
    if ( is_zero() ) 
    {
        return 1;
    }
    else
    {
        if ( (dt->dig())[0]==0 )  // first LIMB is zero
	{
	    return 0;
	}

	if ( ex < underflow )  // underflow
	{
	    return 0;
	}

	if ( ex > overflow )  // overflow
	{
	    return 0;
	}
    }

    return 1;
}
//--------------


void
hfguts::normalize()
{
    assert(dtwrtbl);

    if (normalized())  return;

    ulong f;
    for (f=0; f<prec(); ++f)    // search first digit != 0
    {
        if ( (dt->dig())[f]!=0 )  break;
    }

    if ( f!=0 )
    {
        (*data()).shift_left(prec(),f);

	ex -= f;

        if ( f>=prec() )  set_zero();  // all digits are 0
    }

    if ( ex < underflow )  set_zero();  // underflow

    if ( ex > +overflow )  // overflow
    {
	if ( sg==0 )  sg=+1;

        assert( 0*(int)" OVERFLOW " );  // forbidden
    }
}
//--------------


int
hfguts::check() const
{
    if ( dt ) 
    {
	dt->check();
	assert( pr<=(dt->size()) );
    }

    assert( nguts>=0 );

    return 0;
}
//--------------


hfdata*
hfguts::data() const
{
    assert ( dt );
    return dt;
}
//--------------
