
#include <math.h>
#include <iostream.h>
#include <fstream.h>
#include <assert.h>

#include "hfloatfu.h"
#include "hfguts.h"
#include "hfdata.h"


// for debug:
#define PR(x)

#define SAFE(x) x


#define FTEST(what)  assert( file.good() )


int
binsave_limbs(const char *fname, const hfloat &a, long n, long s)  //=0, =0
//
// return: 0 ==ok
//         -1==fail
//
{
    PR( long bfsz; );
    LIMB *ad;
    int bufct;
    const int buflen=4096;
    unsigned char buf[4096];

    fstream file;
    file.open(fname, ios::out | ios::bin | ios::trunc);  // borland C wants 'ios::binary'
    assert (file.good ());


    if( (0==n) || (n>(long)a.prec()) )  n=(long)a.prec();
    if( n<0 )  n=(long)a.prec()+n;
    if( s<0 )  s=(long)a.prec()+s;

    if( (s>n) || (n>(long)a.prec()) )
    {
        cerr<< "\n binsave_limbs(): meaningless s,n - combination "<<endl;
        return -2;
    }

    ad=(*(a.guts())).data()->dig();


    if( (hfdata::rx2pw) )
    {
         const unsigned char left_bit=0x80;
         long k=s;
         unsigned mr,ak;
         unsigned char mw, t;


         mr=(hfdata::rx>>1);       // bit read mask
         ak=ad[k];
         mw=left_bit;              // bit write mask
         t=0;
	 bufct=0;

         while(1)
	 {
             if(mr & ak)
                 t|=mw;

             mw>>=1;
             if(mw==0)
             {
		 buf[bufct]=t;
		 bufct++;

	         if( bufct==buflen )
		 {
		     file.write(buf,buflen);
		     FTEST(" write ");
		     bufct=0;
		 }

		 t=0;
		 mw=left_bit;
	     }

             mr>>=1;
             if(mr==0)
             {
                k++;
                if(k==n)
		{
                    if(mw!=left_bit)
		    {
		        buf[bufct]=t;
			bufct++;
			file.write(buf,bufct);
			FTEST(" write ");
			bufct=0;
		    }

		    goto thatsit;
		}

                ak=ad[k];
                mr=(hfdata::rx>>1);
	     }
	 }

       thatsit:

	 if(bufct)
	 {
	     file.write(buf,bufct);
	     FTEST(" write ");
	 }

	 PR( bfsz=hfdata::rxbits*n/8; );
    }
    else  // RADIX not a pow of 2
    {
        file.write(ad+s,sizeof(LIMB)*(n-s));
	FTEST(" write ");
	PR( bfsz=sizeof(LIMB)*n; );
    }



    PR( cout<<"\n binfile-size should be "<< bfsz <<" bytes "; );

    FTEST(" end ");

    file.close();
    if( !file.good() )
    {
        cerr<< "\n binsave(): close FAILED ! "<<endl;
	return -1;
    }

    return 0;
}
//================== end BINSAVE_LIMBS =============================
