
#include <math.h>
#include <iostream.h>
#include <assert.h>

#include "hfloatfu.h"
#include "mybuiltin.h"
#include "iteratio.h"


// for debug:
#define PR(x)


// whether to check that the last step in iteration really 
// produced the full precision: 
// if there is a precision loss (or other failure) then 
// its effect typically shows up at the last step.
const int check_last_step = 0;

int
poly_root_iteration(hfloat &x, ulong deg, const long *num, const long *den, ulong startprec)
//
//   iteration for x (where p(x)==0):
//
//   x <- x-p(x)/p'(x)
//   or:
//   x-=p(x)/p'(x)
//
{
    long *dnum, *dden;
    ulong n = x.prec();
    hfloat a(n);

    PR( cout << "\n\n start Poly_Root() \n"; );

    dnum = new long[deg];
    assert(dnum);
    dden = new long[deg];
    assert(dden);

    PR( print("\n Poly_Root(): x = \n",x,10); );

    PR( print_poly("\n p(x)== \n",deg,num,den); );

    poly_derive(deg,num,den,dnum,dden);
    PR( print_poly("\n p'(x)== \n",deg,dnum,dden); );


//int poly_root_iteration(, int startprec):

    int j;
    ulong prec,newprec;
    ulong precgoal = x.prec();

    hfloat t(precgoal), t2(precgoal);

    startprec = 0;

    if ( BREAK_COND(startprec) )  return 0;

    if ( startprec<PREC_THRES )
    {
        n = START_CALC_PREC;
        t.prec(n);
        t2.prec(n);
        x.prec(n);

        j = 0;
        do
        {
                                      PR( print("\n x = ",x); );

            polynom(x,deg,num,den,t); PR( print("\n p(x) = ",t); );

            newprec = -t.exp();    PR( cout << "\n => newprec =" << newprec; );

            polynom(x,deg-1,dnum,dden,t2); PR( print("\n p'(x) = ",t2); );

            div(t,t2,t);         PR( print("\n p/p' = ",t); );

            sub(x,t,x);          //PR( print("\n c-p/p' = ",x); );

            //            PREC_INFO(newprec,n);

            if ( ++j>20 )  ITER_ERR_1(j);
        }
        while(newprec < PREC_THRES/2);
    }
    else
    {
        newprec = startprec;
        n = START_PREC2;
        t.prec(n);
        t2.prec(n);
        x.prec(n);

        //        PREC_INFO(newprec,n);
    }

    prec = 0;

    for(j=0; j<MAX_REC; ++j)  // ---------------- ITERATION --------------
    {
        //        PREC_INFO(newprec,n);
        OOOPSQ(newprec,n);

 	n = MIN(2*n,precgoal);

        t.prec(n);
        t2.prec(n);
        x.prec(n);

                                     PR( print("\n c = ",x); );

        polynom(x,deg,num,den,t);    PR( print("\n p(x) = ",t); );

        prec = newprec;
        newprec = -t.exp();       PR( cout << "\n => newprec =" << newprec; );

        if (BREAK_COND(newprec))
        {
            //            PREC_INFO(newprec,n);
            break;
        }

        polynom(x,deg-1,dnum,dden,t2); PR( print("\n p'(x) = ",t2); );

        div(t,t2,t);              PR( print("\n p/p' = ",t); );

        sub(x,t,x);               //PR( print("\n c-p/p' = ",x); );

	if (!CHECK_LAST_STEP)  if (EARLY_COND)  break;
    }
    // ---------------- end of ITERATION ---------------------


    if ( j==MAX_REC )  ITER_ERR_2(j);

    PR( cout << "\n Poly_Root_Iteration(): elapsed time: " << return_elapsed_time() << " sec. \n"; );

    delete [] dden;
    delete [] dnum;

    return j;
}
// ============================ end POLY_ROOT_ITERATION =================================












