

#include <math.h>

#include "hfloatfu.h"
//#include "hfguts.h"
//#include "hfdata.h"


void
sumalt( void (*termfct)(ulong, hfloat &), hfloat &s)
//
// compute \sum_{k=0}^{\infty}{termfct(k)}
// works only for alterating sums,
// i.e. termfct must be of type (-1)^k*positive(k)
//
{
    ulong p = s.prec();
    double drx = hfloat::radix();
    ulong n = (ulong)ceil( p*log(drx)/log(3.0+sqrt(8.0)) );
    //    cout << " n= " << n << endl;

    hfloat d;  d = 8;
    sqrt(d,d);
    d += 3;
    pow(d,n,d);
    hfloat c;
    inv(d,c);
    d += c;
    d /= 2; 
    //    print(" d=",d,8);

    c = d;
    s = 0;
    hfloat b;  b = 1;
    hfloat t;
    for (ulong k=0; k<n; ++k)
    {
        c -= b;
        termfct(k,t);
        t *= c;
        s += t;
        b *= (2*(n+k)*(n-k)); 
        b /= ((2*k+1)*(k+1)); 
    }

    s /= d;
}
//=================== end SUMALT =======================


/*
EXAMPLES: with

void
gregory_term(ulong k, hfloat &t)
// for arctan(1) = \sum_{k=0}^{\infty}{(-1)^k*1/(2*k+1)}
{
    t = 1;
    if ( k&1 )  t.negate();

    t /= (2*k+1);
}
//---------------

void
catalan_term(ulong k, hfloat &t)
// for catalan = \sum_{k=0}^{\infty}{(-1)^k*1/(2*k+1)}
{
    t = 1;
    if ( k&1 )  t.negate();

    t /= ((2*k+1)*(2*k+1));
}
//---------------


hfloat(s,256);  // less than , say 1024 decimal digits

sumalt(gregory_term, s);  // compute pi as arctan(1)
sumalt(catalan_term, s);  // compute catalan=0.91596...

*/
