
#include <math.h>
#include <iostream.h>

#include "hfloatfu.h"
#include "hfverbosity.h"



// see borwein^2 p.170:
#define LOG_PREC_R(k,r)  -(log(16.0*sqrt(r))+k*log(2.0)-pow(2.0,k)*sqrt(r)*M_PI) 
#define LOG_PREC(k)  LOG_PREC_R((double)(k), 1.0 )

#define LIMB_PREC(k)  (long)floor(LOG_PREC(k)/log(drx))  // precision in LIMBS


int 
pi_2nd_order(hfloat &p)
//
// quadratic iteration for pi
//
// return number of iterations needed
{
    if ( hfverbosity::piname )  
        cout << "\n ===== pi_2nd_order(): ===== " << endl;

    long n = p.prec();

    long prec;
    long pnp = hfverbosity::pinumprec;
    double drx;
    hfloat y(n), a(n), z(n);

    drx=(double)a.radix();

    isqrt(2,y);                    // y_0 = 1/sqrt(2)
    a=1;                   
    a/=2;                          // a_0 = 1/2

    int k;
    for(k=1;  ; ++k)
    {
	// Y_k:
	sqr(y,y);                        // y^2
	sub(1,y,y);                      // (1-y^2)
    
	z=1;                             // inv root --> 1.0000000000
	isqrt(y,z,prec);                 // (1-y^2)^(-1/2)
	sub(z,1,y);                      // (1-y^2)^(-1/2)-1
	add(y,2,p);                      // (1-y^2)^(-1/2)+1
	z=1; 
	z/=2;                            // inv --> .49999999999999
	inv(p,z,prec);                   // 1/(y^(-1/2)+1)
	y*=z;                            // new y=(y^(-1/2)-1)/(y^(-1/2)+1)
    
	// A_k:
	add(y,1,p);                       // y+1
	sqr(p,p);                         // (y+1)^2
	mul(p,a,a);                       // a*(y+1)^2

	mul2pow(y,(k-1)+1,z);             // y*2^(2*(k-1)+3)
    
	a-=z;                             // new a=a*(y+1)^2-2^(k+1)*y
        if ( hfverbosity::pinums )  print("\nA_k=\n",a,pnp);
        prec = LIMB_PREC(k);
        if ( hfverbosity::piprec )
            cout << "\n precision=" << prec << endl;
	if( prec>=n )  break;
    }

    inv(a,p);         // ! pi !

    return k;
}
//========================== end PI_2ND_ORDER ==========================

