 
#include <math.h>
#include <assert.h>

#include "hfloatfu.h"


// for debug:
//#include <iostream.h>
#define PR(x)  



int
log_agm(const hfloat &a, hfloat &z)
//
// z = log(a)
// cf. borwein^2 p.220
// abs(log(x)-R'(10^-n)+R'(x*10^-n)) <= n/(10^(2*(n-1)))
//   for  abs(x-1) < 1/2,  n >= 3
//
{
    PR( cout << "\n\n start log_agm() \n"; );
    PR( print("\n arg=\n",a,12); );

    //    assert( !same_mantissa(a,z) );
    assert( (a<1.5001) *(int)"log_agm(): out of range" );
    assert( (a>0.4999) *(int)"log_agm(): out of range" );


    const double  drx = (double)hfloat::radix();
    long  p = z.prec();
    long  n = (long)((p*log(drx)+20.0)/(2.0*log(drx))+5);
    PR( cout << "\n n=" << n; );

    hfloat b(p), x(p);


    b = 1;
    mul_by_radix_pow(b,-n,b);
    PR( print("\n log_agm(): (1)b=\n",b,10); );

    r_prime(b,x,p);  // R'(10^-n)
    inv(x,x);
    PR( print("\n log_agm(): sum1=\n",x,10); );

    b = a;
    mul_by_radix_pow(b,-n,b);
    PR( print("\n log_agm(): (2)b=\n",b,10); );

    r_prime(b,b,p);  // R'(x*10^-n)
    inv(b,b);
    PR( print("\n log_agm(): sum2=\n",b,10); );

    sub(x,b,z);
    PR( print("\n log_agm(): sum1-sum2=\n",z,10); );


    return 0;
}
// ================ end LOG_AGM =====================


